/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.benchmark;

import java.io.IOException;
import org.apache.giraph.graph.BasicComputation;
import org.apache.giraph.graph.Vertex;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;

public class PageRankComputation
extends BasicComputation<IntWritable, FloatWritable, NullWritable, FloatWritable> {
    public static final String SUPERSTEP_COUNT = "giraph.pageRank.superstepCount";

    @Override
    public void compute(Vertex<IntWritable, FloatWritable, NullWritable> vertex, Iterable<FloatWritable> messages) throws IOException {
        if (this.getSuperstep() >= 1L) {
            float sum = 0.0f;
            for (FloatWritable message : messages) {
                sum += message.get();
            }
            vertex.getValue().set(0.15f / (float)this.getTotalNumVertices() + 0.85f * sum);
        }
        if (this.getSuperstep() < (long)this.getConf().getInt(SUPERSTEP_COUNT, 0)) {
            this.sendMessageToAllEdges(vertex, new FloatWritable(vertex.getValue().get() / (float)vertex.getNumEdges()));
        } else {
            vertex.voteToHalt();
        }
    }
}

