/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.benchmark;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.giraph.benchmark.BenchmarkOption;
import org.apache.giraph.benchmark.GiraphBenchmark;
import org.apache.giraph.benchmark.PageRankComputation;
import org.apache.giraph.combiner.FloatSumMessageCombiner;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.GiraphTypes;
import org.apache.giraph.edge.IntNullArrayEdges;
import org.apache.giraph.graph.Language;
import org.apache.giraph.io.formats.PseudoRandomIntNullVertexInputFormat;
import org.apache.giraph.jython.JythonUtils;
import org.apache.giraph.scripting.DeployType;
import org.apache.giraph.scripting.ScriptLoader;
import org.apache.giraph.utils.DistributedCacheUtils;
import org.apache.giraph.utils.ReflectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class PageRankBenchmark
extends GiraphBenchmark {
    @Override
    public Set<BenchmarkOption> getBenchmarkOptions() {
        return Sets.newHashSet((Object[])new BenchmarkOption[]{BenchmarkOption.VERTICES, BenchmarkOption.EDGES_PER_VERTEX, BenchmarkOption.SUPERSTEPS, BenchmarkOption.LOCAL_EDGES_MIN_RATIO, BenchmarkOption.JYTHON, BenchmarkOption.SCRIPT_PATH});
    }

    @Override
    protected void prepareConfiguration(GiraphConfiguration conf, CommandLine cmd) {
        if (BenchmarkOption.JYTHON.optionTurnedOn(cmd)) {
            String script;
            DeployType deployType;
            GiraphTypes types = new GiraphTypes();
            types.inferFrom(PageRankComputation.class);
            if (BenchmarkOption.SCRIPT_PATH.optionTurnedOn(cmd)) {
                deployType = DeployType.DISTRIBUTED_CACHE;
                String path = BenchmarkOption.SCRIPT_PATH.getOptionValue(cmd);
                Path hadoopPath = new Path(path);
                Path remotePath = DistributedCacheUtils.copyAndAdd(hadoopPath, conf);
                script = remotePath.toString();
            } else {
                deployType = DeployType.RESOURCE;
                script = ReflectionUtils.getPackagePath(this) + "/page-rank.py";
            }
            ScriptLoader.setScriptsToLoad((Configuration)conf, script, deployType, Language.JYTHON);
            types.writeIfUnset(conf);
            JythonUtils.init(conf, "PageRank");
        } else {
            conf.setComputationClass(PageRankComputation.class);
        }
        conf.setOutEdgesClass(IntNullArrayEdges.class);
        conf.setMessageCombinerClass(FloatSumMessageCombiner.class);
        conf.setVertexInputFormatClass(PseudoRandomIntNullVertexInputFormat.class);
        conf.setInt("giraph.pseudoRandomInputFormat.aggregateVertices", BenchmarkOption.VERTICES.getOptionIntValue(cmd));
        conf.setInt("giraph.pseudoRandomInputFormat.edgesPerVertex", BenchmarkOption.EDGES_PER_VERTEX.getOptionIntValue(cmd));
        conf.setInt("giraph.pageRank.superstepCount", BenchmarkOption.SUPERSTEPS.getOptionIntValue(cmd));
        conf.setFloat("giraph.pseudoRandomInputFormat.localEdgesMinRatio", BenchmarkOption.LOCAL_EDGES_MIN_RATIO.getOptionFloatValue(cmd, 0.0f));
    }

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run((Tool)new PageRankBenchmark(), (String[])args));
    }
}

