/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.benchmark;

import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.giraph.benchmark.BenchmarkOption;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.job.GiraphJob;
import org.apache.giraph.utils.LogVersions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Tool;
import org.apache.log4j.Logger;

public abstract class GiraphBenchmark
implements Tool {
    private static final Logger LOG = Logger.getLogger(GiraphBenchmark.class);
    private Configuration conf;

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public int run(String[] args) throws Exception {
        Set<BenchmarkOption> giraphOptions = this.getBenchmarkOptions();
        giraphOptions.add(BenchmarkOption.HELP);
        giraphOptions.add(BenchmarkOption.VERBOSE);
        giraphOptions.add(BenchmarkOption.WORKERS);
        Options options = new Options();
        for (BenchmarkOption giraphOption : giraphOptions) {
            giraphOption.addToOptions(options);
        }
        HelpFormatter formatter = new HelpFormatter();
        if (args.length == 0) {
            formatter.printHelp(this.getClass().getName(), options, true);
            return 0;
        }
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        for (BenchmarkOption giraphOption : giraphOptions) {
            if (giraphOption.checkOption(cmd, LOG)) continue;
            return -1;
        }
        if (BenchmarkOption.HELP.optionTurnedOn(cmd)) {
            formatter.printHelp(this.getClass().getName(), options, true);
            return 0;
        }
        GiraphJob job = new GiraphJob(this.getConf(), this.getClass().getName());
        int workers = Integer.parseInt(BenchmarkOption.WORKERS.getOptionValue(cmd));
        GiraphConfiguration giraphConf = job.getConfiguration();
        giraphConf.addWorkerObserverClass(LogVersions.class);
        giraphConf.addMasterObserverClass(LogVersions.class);
        giraphConf.setWorkerConfiguration(workers, workers, 100.0f);
        this.prepareConfiguration(giraphConf, cmd);
        boolean isVerbose = false;
        if (BenchmarkOption.VERBOSE.optionTurnedOn(cmd)) {
            isVerbose = true;
        }
        if (job.run(isVerbose)) {
            return 0;
        }
        return -1;
    }

    public abstract Set<BenchmarkOption> getBenchmarkOptions();

    protected abstract void prepareConfiguration(GiraphConfiguration var1, CommandLine var2);
}

