/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.benchmark;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;

public class BenchmarkOption {
    public static final BenchmarkOption HELP = new BenchmarkOption("h", "help", false, "Help");
    public static final BenchmarkOption VERBOSE = new BenchmarkOption("v", "verbose", false, "Verbose");
    public static final BenchmarkOption WORKERS = new BenchmarkOption("w", "workers", true, "Number of workers", "Need to choose the number of workers (-w)");
    public static final BenchmarkOption SUPERSTEPS = new BenchmarkOption("s", "supersteps", true, "Supersteps to execute before finishing", "Need to set the number of supersteps (-s)");
    public static final BenchmarkOption VERTICES = new BenchmarkOption("V", "aggregateVertices", true, "Aggregate vertices", "Need to set the aggregate vertices (-V)");
    public static final BenchmarkOption EDGES_PER_VERTEX = new BenchmarkOption("e", "edgesPerVertex", true, "Edges per vertex", "Need to set the number of edges per vertex (-e)");
    public static final BenchmarkOption LOCAL_EDGES_MIN_RATIO = new BenchmarkOption("l", "localEdgesMinRatio", true, "Minimum ratio of partition-local edges (default is 0)");
    public static final BenchmarkOption JYTHON = new BenchmarkOption("j", "jython", false, "Use jython implementation");
    public static final BenchmarkOption SCRIPT_PATH = new BenchmarkOption("sp", "scriptPath", true, "Path to script for computation, can be local or HDFS path");
    private String shortOption;
    private String longOption;
    private boolean hasArgument;
    private String description;
    private String missingMessage;

    public BenchmarkOption(String shortOption, String longOption, boolean hasArgument, String description) {
        this(shortOption, longOption, hasArgument, description, null);
    }

    public BenchmarkOption(String shortOption, String longOption, boolean hasArgument, String description, String missingMessage) {
        this.shortOption = shortOption;
        this.longOption = longOption;
        this.hasArgument = hasArgument;
        this.description = description;
        this.missingMessage = missingMessage;
    }

    public boolean isRequired() {
        return this.missingMessage != null;
    }

    public void addToOptions(Options options) {
        options.addOption(this.shortOption, this.longOption, this.hasArgument, this.description);
    }

    public boolean checkOption(CommandLine cmd, Logger log) {
        if (!this.isRequired()) {
            return true;
        }
        if (!cmd.hasOption(this.shortOption)) {
            log.info((Object)this.missingMessage);
            return false;
        }
        return true;
    }

    public boolean optionTurnedOn(CommandLine cmd) {
        return cmd.hasOption(this.shortOption);
    }

    public String getOptionValue(CommandLine cmd) {
        return cmd.getOptionValue(this.shortOption);
    }

    public int getOptionIntValue(CommandLine cmd) {
        return Integer.parseInt(this.getOptionValue(cmd));
    }

    public int getOptionIntValue(CommandLine cmd, int defaultValue) {
        return this.optionTurnedOn(cmd) ? this.getOptionIntValue(cmd) : defaultValue;
    }

    public long getOptionLongValue(CommandLine cmd) {
        return Long.parseLong(this.getOptionValue(cmd));
    }

    public float getOptionFloatValue(CommandLine cmd) {
        return Float.parseFloat(this.getOptionValue(cmd));
    }

    public float getOptionFloatValue(CommandLine cmd, float defaultValue) {
        return this.optionTurnedOn(cmd) ? this.getOptionFloatValue(cmd) : defaultValue;
    }
}

