/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.benchmark;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.giraph.aggregators.LongSumAggregator;
import org.apache.giraph.benchmark.BenchmarkOption;
import org.apache.giraph.benchmark.GiraphBenchmark;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.graph.BasicComputation;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.formats.PseudoRandomVertexInputFormat;
import org.apache.giraph.master.DefaultMasterCompute;
import org.apache.giraph.utils.MasterLoggingAggregator;
import org.apache.giraph.worker.DefaultWorkerContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class AggregatorsBenchmark
extends GiraphBenchmark {
    private static final String AGGREGATORS_NUM = "aggregatorsbenchmark.num";
    private static final BenchmarkOption AGGREGATORS = new BenchmarkOption("a", "aggregators", true, "Aggregators", "Need to set number of aggregators (-a)");

    private static int getNumAggregators(Configuration conf) {
        return conf.getInt(AGGREGATORS_NUM, 0);
    }

    private static int getWorkerContextAggregated(Configuration conf, long superstep) {
        return superstep <= 0L ? 0 : conf.getInt("workers", 0) * 3;
    }

    private static void assertEquals(long expected, long actual) {
        if (expected != actual) {
            throw new RuntimeException("expected: " + expected + ", actual: " + actual);
        }
    }

    @Override
    public Set<BenchmarkOption> getBenchmarkOptions() {
        return Sets.newHashSet((Object[])new BenchmarkOption[]{BenchmarkOption.VERTICES, AGGREGATORS});
    }

    @Override
    protected void prepareConfiguration(GiraphConfiguration conf, CommandLine cmd) {
        conf.setComputationClass(AggregatorsBenchmarkComputation.class);
        conf.setMasterComputeClass(AggregatorsBenchmarkMasterCompute.class);
        conf.setVertexInputFormatClass(PseudoRandomVertexInputFormat.class);
        conf.setWorkerContextClass(AggregatorsBenchmarkWorkerContext.class);
        conf.setLong("giraph.pseudoRandomInputFormat.aggregateVertices", BenchmarkOption.VERTICES.getOptionLongValue(cmd));
        conf.setLong("giraph.pseudoRandomInputFormat.edgesPerVertex", 1L);
        conf.setInt(AGGREGATORS_NUM, AGGREGATORS.getOptionIntValue(cmd));
        conf.setInt("workers", conf.getInt("giraph.maxWorkers", -1));
        MasterLoggingAggregator.setUseMasterLoggingAggregator(true, conf);
    }

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run((Tool)new AggregatorsBenchmark(), (String[])args));
    }

    public static class AggregatorsBenchmarkWorkerContext
    extends DefaultWorkerContext {
        @Override
        public void preSuperstep() {
            this.addToWorkerAggregators(1);
            this.checkAggregators();
            MasterLoggingAggregator.aggregate("everything fine", this, this.getConf());
        }

        @Override
        public void postSuperstep() {
            this.addToWorkerAggregators(2);
            this.checkAggregators();
        }

        private void checkAggregators() {
            int n = AggregatorsBenchmark.getNumAggregators(this.getContext().getConfiguration());
            long superstep = this.getSuperstep();
            int w = AggregatorsBenchmark.getWorkerContextAggregated(this.getContext().getConfiguration(), superstep);
            for (int i = 0; i < n; ++i) {
                AggregatorsBenchmark.assertEquals(superstep * (this.getTotalNumVertices() * (long)i) + (long)w, ((LongWritable)this.getAggregatedValue("w" + i)).get());
                AggregatorsBenchmark.assertEquals(-(superstep * (long)i), ((LongWritable)this.getAggregatedValue("m" + i)).get());
                AggregatorsBenchmark.assertEquals(superstep * this.getTotalNumVertices() * (long)i, ((LongWritable)this.getAggregatedValue("p" + i)).get());
            }
        }

        private void addToWorkerAggregators(int valueToAdd) {
            int n = AggregatorsBenchmark.getNumAggregators(this.getContext().getConfiguration());
            for (int i = 0; i < n; ++i) {
                this.aggregate("w" + i, new LongWritable((long)valueToAdd));
            }
        }
    }

    public static class AggregatorsBenchmarkMasterCompute
    extends DefaultMasterCompute {
        @Override
        public void initialize() throws InstantiationException, IllegalAccessException {
            int n = AggregatorsBenchmark.getNumAggregators(this.getConf());
            for (int i = 0; i < n; ++i) {
                this.registerAggregator("w" + i, LongSumAggregator.class);
                this.registerAggregator("m" + i, LongSumAggregator.class);
                this.registerPersistentAggregator("p" + i, LongSumAggregator.class);
            }
        }

        @Override
        public void compute() {
            int n = AggregatorsBenchmark.getNumAggregators(this.getConf());
            long superstep = this.getSuperstep();
            int w = AggregatorsBenchmark.getWorkerContextAggregated(this.getConf(), superstep);
            for (int i = 0; i < n; ++i) {
                this.setAggregatedValue("m" + i, new LongWritable(-superstep * (long)i));
                if (superstep <= 0L) continue;
                AggregatorsBenchmark.assertEquals(superstep * (this.getTotalNumVertices() * (long)i) + (long)w, ((LongWritable)this.getAggregatedValue("w" + i)).get());
                AggregatorsBenchmark.assertEquals(superstep * this.getTotalNumVertices() * (long)i, ((LongWritable)this.getAggregatedValue("p" + i)).get());
            }
        }
    }

    public static class AggregatorsBenchmarkComputation
    extends BasicComputation<LongWritable, DoubleWritable, DoubleWritable, DoubleWritable> {
        @Override
        public void compute(Vertex<LongWritable, DoubleWritable, DoubleWritable> vertex, Iterable<DoubleWritable> messages) throws IOException {
            int n = AggregatorsBenchmark.getNumAggregators(this.getConf());
            long superstep = this.getSuperstep();
            int w = AggregatorsBenchmark.getWorkerContextAggregated(this.getConf(), superstep);
            for (int i = 0; i < n; ++i) {
                this.aggregate("w" + i, new LongWritable((superstep + 1L) * (long)i));
                this.aggregate("p" + i, new LongWritable((long)i));
                AggregatorsBenchmark.assertEquals(superstep * (this.getTotalNumVertices() * (long)i) + (long)w, ((LongWritable)this.getAggregatedValue("w" + i)).get());
                AggregatorsBenchmark.assertEquals(-(superstep * (long)i), ((LongWritable)this.getAggregatedValue("m" + i)).get());
                AggregatorsBenchmark.assertEquals(superstep * this.getTotalNumVertices() * (long)i, ((LongWritable)this.getAggregatedValue("p" + i)).get());
            }
            if (superstep > 2L) {
                vertex.voteToHalt();
            }
        }
    }
}

