/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.aggregators.matrix.sparse;

import it.unimi.dsi.fastutil.ints.Int2LongMap;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public class LongSparseVector
implements Writable {
    private Int2LongOpenHashMap entries = null;

    public LongSparseVector() {
        this.initialize(16);
    }

    public LongSparseVector(int size) {
        this.initialize(size);
    }

    private void initialize(int size) {
        this.entries = new Int2LongOpenHashMap(size);
        this.entries.defaultReturnValue(0L);
    }

    public long get(int i) {
        return this.entries.get(i);
    }

    public void set(int i, long value) {
        this.entries.put(i, value);
    }

    public void clear() {
        this.entries.clear();
    }

    public void add(LongSparseVector other) {
        ObjectIterator iter = other.entries.int2LongEntrySet().fastIterator();
        while (iter.hasNext()) {
            Int2LongMap.Entry entry = (Int2LongMap.Entry)iter.next();
            this.entries.addTo(entry.getIntKey(), entry.getLongValue());
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.entries.size());
        ObjectIterator iter = this.entries.int2LongEntrySet().fastIterator();
        while (iter.hasNext()) {
            Int2LongMap.Entry entry = (Int2LongMap.Entry)iter.next();
            out.writeInt(entry.getIntKey());
            out.writeLong(entry.getLongValue());
        }
    }

    public void readFields(DataInput in) throws IOException {
        int size = in.readInt();
        this.initialize(size);
        for (int i = 0; i < size; ++i) {
            int row = in.readInt();
            long value = in.readLong();
            this.entries.put(row, value);
        }
    }
}

