/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.aggregators.matrix.sparse;

import org.apache.giraph.aggregators.AggregatorUsage;
import org.apache.giraph.aggregators.matrix.MatrixSumAggregator;
import org.apache.giraph.aggregators.matrix.sparse.LongSparseMatrix;
import org.apache.giraph.aggregators.matrix.sparse.LongSparseVector;
import org.apache.giraph.aggregators.matrix.sparse.LongSparseVectorSumAggregator;
import org.apache.giraph.master.MasterAggregatorUsage;
import org.apache.giraph.worker.WorkerAggregatorUsage;

public class LongSparseMatrixSumAggregator
extends MatrixSumAggregator {
    private LongSparseVector singletonVector = new LongSparseVector();

    public LongSparseMatrixSumAggregator(String name) {
        super(name);
    }

    public void register(int numRows, MasterAggregatorUsage master) throws InstantiationException, IllegalAccessException {
        for (int i = 0; i < numRows; ++i) {
            master.registerAggregator(this.getRowAggregatorName(i), LongSparseVectorSumAggregator.class);
        }
    }

    public void aggregate(int i, int j, long v, WorkerAggregatorUsage worker) {
        this.singletonVector.clear();
        this.singletonVector.set(j, v);
        worker.aggregate(this.getRowAggregatorName(i), this.singletonVector);
    }

    public void setMatrix(LongSparseMatrix matrix, MasterAggregatorUsage master) {
        int numRows = matrix.getNumRows();
        for (int i = 0; i < numRows; ++i) {
            master.setAggregatedValue(this.getRowAggregatorName(i), matrix.getRow(i));
        }
    }

    public LongSparseMatrix getMatrix(int numRows, AggregatorUsage aggUser) {
        LongSparseMatrix matrix = new LongSparseMatrix(numRows);
        for (int i = 0; i < numRows; ++i) {
            LongSparseVector vec = (LongSparseVector)aggUser.getAggregatedValue(this.getRowAggregatorName(i));
            matrix.setRow(i, vec);
        }
        return matrix;
    }
}

