/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.aggregators.matrix.sparse;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.apache.giraph.aggregators.matrix.sparse.LongSparseVector;

public class LongSparseMatrix {
    private int numRows;
    private Int2ObjectOpenHashMap<LongSparseVector> rows;

    public LongSparseMatrix(int numRows) {
        this.numRows = numRows;
        this.rows = new Int2ObjectOpenHashMap(numRows);
        this.rows.defaultReturnValue(null);
    }

    public void initialize() {
        this.rows.clear();
        for (int i = 0; i < this.numRows; ++i) {
            this.setRow(i, new LongSparseVector());
        }
    }

    public int getNumRows() {
        return this.numRows;
    }

    public long get(int i, int j) {
        return ((LongSparseVector)this.rows.get(i)).get(j);
    }

    public void set(int i, int j, long v) {
        ((LongSparseVector)this.rows.get(i)).set(j, v);
    }

    LongSparseVector getRow(int i) {
        return (LongSparseVector)this.rows.get(i);
    }

    void setRow(int i, LongSparseVector vec) {
        this.rows.put(i, (Object)vec);
    }
}

