/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.aggregators.matrix.sparse;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public class IntSparseVector
implements Writable {
    private Int2IntOpenHashMap entries = null;

    public IntSparseVector() {
        this.initialize(16);
    }

    public IntSparseVector(int size) {
        this.initialize(size);
    }

    private void initialize(int size) {
        this.entries = new Int2IntOpenHashMap(size);
        this.entries.defaultReturnValue(0);
    }

    public int get(int i) {
        return this.entries.get(i);
    }

    public void set(int i, int value) {
        this.entries.put(i, value);
    }

    public void clear() {
        this.entries.clear();
    }

    public void add(IntSparseVector other) {
        ObjectIterator iter = other.entries.int2IntEntrySet().fastIterator();
        while (iter.hasNext()) {
            Int2IntMap.Entry entry = (Int2IntMap.Entry)iter.next();
            this.entries.addTo(entry.getIntKey(), entry.getIntValue());
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.entries.size());
        ObjectIterator iter = this.entries.int2IntEntrySet().fastIterator();
        while (iter.hasNext()) {
            Int2IntMap.Entry entry = (Int2IntMap.Entry)iter.next();
            out.writeInt(entry.getIntKey());
            out.writeInt(entry.getIntValue());
        }
    }

    public void readFields(DataInput in) throws IOException {
        int size = in.readInt();
        this.initialize(size);
        for (int i = 0; i < size; ++i) {
            int row = in.readInt();
            int value = in.readInt();
            this.entries.put(row, value);
        }
    }
}

