/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.aggregators.matrix.sparse;

import org.apache.giraph.aggregators.AggregatorUsage;
import org.apache.giraph.aggregators.matrix.MatrixSumAggregator;
import org.apache.giraph.aggregators.matrix.sparse.IntSparseMatrix;
import org.apache.giraph.aggregators.matrix.sparse.IntSparseVector;
import org.apache.giraph.aggregators.matrix.sparse.IntSparseVectorSumAggregator;
import org.apache.giraph.master.MasterAggregatorUsage;
import org.apache.giraph.worker.WorkerAggregatorUsage;

public class IntSparseMatrixSumAggregator
extends MatrixSumAggregator {
    private IntSparseVector singletonVector = new IntSparseVector();

    public IntSparseMatrixSumAggregator(String name) {
        super(name);
    }

    public void register(int numRows, MasterAggregatorUsage master) throws InstantiationException, IllegalAccessException {
        for (int i = 0; i < numRows; ++i) {
            master.registerAggregator(this.getRowAggregatorName(i), IntSparseVectorSumAggregator.class);
        }
    }

    public void aggregate(int i, int j, int v, WorkerAggregatorUsage worker) {
        this.singletonVector.clear();
        this.singletonVector.set(j, v);
        worker.aggregate(this.getRowAggregatorName(i), this.singletonVector);
    }

    public void setMatrix(IntSparseMatrix matrix, MasterAggregatorUsage master) {
        int numRows = matrix.getNumRows();
        for (int i = 0; i < numRows; ++i) {
            master.setAggregatedValue(this.getRowAggregatorName(i), matrix.getRow(i));
        }
    }

    public IntSparseMatrix getMatrix(int numRows, AggregatorUsage aggUser) {
        IntSparseMatrix matrix = new IntSparseMatrix(numRows);
        for (int i = 0; i < numRows; ++i) {
            IntSparseVector vec = (IntSparseVector)aggUser.getAggregatedValue(this.getRowAggregatorName(i));
            matrix.setRow(i, vec);
        }
        return matrix;
    }
}

