/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.aggregators.matrix.sparse;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.apache.giraph.aggregators.matrix.sparse.IntSparseVector;

public class IntSparseMatrix {
    private int numRows;
    private Int2ObjectOpenHashMap<IntSparseVector> rows;

    public IntSparseMatrix(int numRows) {
        this.numRows = numRows;
        this.rows = new Int2ObjectOpenHashMap(numRows);
        this.rows.defaultReturnValue(null);
    }

    public void initialize() {
        this.rows.clear();
        for (int i = 0; i < this.numRows; ++i) {
            this.setRow(i, new IntSparseVector());
        }
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int get(int i, int j) {
        return ((IntSparseVector)this.rows.get(i)).get(j);
    }

    public void set(int i, int j, int v) {
        ((IntSparseVector)this.rows.get(i)).set(j, v);
    }

    IntSparseVector getRow(int i) {
        return (IntSparseVector)this.rows.get(i);
    }

    void setRow(int i, IntSparseVector vec) {
        this.rows.put(i, (Object)vec);
    }
}

