/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.aggregators.matrix.sparse;

import it.unimi.dsi.fastutil.ints.Int2FloatMap;
import it.unimi.dsi.fastutil.ints.Int2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public class FloatSparseVector
implements Writable {
    private Int2FloatOpenHashMap entries = null;

    public FloatSparseVector() {
        this.initialize(16);
    }

    public FloatSparseVector(int size) {
        this.initialize(size);
    }

    private void initialize(int size) {
        this.entries = new Int2FloatOpenHashMap(size);
        this.entries.defaultReturnValue(0.0f);
    }

    public float get(int i) {
        return this.entries.get(i);
    }

    public void set(int i, float value) {
        this.entries.put(i, value);
    }

    public void clear() {
        this.entries.clear();
    }

    public void add(FloatSparseVector other) {
        ObjectIterator iter = other.entries.int2FloatEntrySet().fastIterator();
        while (iter.hasNext()) {
            Int2FloatMap.Entry entry = (Int2FloatMap.Entry)iter.next();
            this.entries.addTo(entry.getIntKey(), entry.getFloatValue());
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.entries.size());
        ObjectIterator iter = this.entries.int2FloatEntrySet().fastIterator();
        while (iter.hasNext()) {
            Int2FloatMap.Entry entry = (Int2FloatMap.Entry)iter.next();
            out.writeInt(entry.getIntKey());
            out.writeFloat(entry.getFloatValue());
        }
    }

    public void readFields(DataInput in) throws IOException {
        int size = in.readInt();
        this.initialize(size);
        for (int i = 0; i < size; ++i) {
            int row = in.readInt();
            float value = in.readFloat();
            this.entries.put(row, value);
        }
    }
}

