/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.aggregators.matrix.sparse;

import org.apache.giraph.aggregators.AggregatorUsage;
import org.apache.giraph.aggregators.matrix.MatrixSumAggregator;
import org.apache.giraph.aggregators.matrix.sparse.FloatSparseMatrix;
import org.apache.giraph.aggregators.matrix.sparse.FloatSparseVector;
import org.apache.giraph.aggregators.matrix.sparse.FloatSparseVectorSumAggregator;
import org.apache.giraph.master.MasterAggregatorUsage;
import org.apache.giraph.worker.WorkerAggregatorUsage;

public class FloatSparseMatrixSumAggregator
extends MatrixSumAggregator {
    private FloatSparseVector singletonVector = new FloatSparseVector();

    public FloatSparseMatrixSumAggregator(String name) {
        super(name);
    }

    public void register(int numRows, MasterAggregatorUsage master) throws InstantiationException, IllegalAccessException {
        for (int i = 0; i < numRows; ++i) {
            master.registerAggregator(this.getRowAggregatorName(i), FloatSparseVectorSumAggregator.class);
        }
    }

    public void aggregate(int i, int j, float v, WorkerAggregatorUsage worker) {
        this.singletonVector.clear();
        this.singletonVector.set(j, v);
        worker.aggregate(this.getRowAggregatorName(i), this.singletonVector);
    }

    public void setMatrix(FloatSparseMatrix matrix, MasterAggregatorUsage master) {
        int numRows = matrix.getNumRows();
        for (int i = 0; i < numRows; ++i) {
            master.setAggregatedValue(this.getRowAggregatorName(i), matrix.getRow(i));
        }
    }

    public FloatSparseMatrix getMatrix(int numRows, AggregatorUsage aggUser) {
        FloatSparseMatrix matrix = new FloatSparseMatrix(numRows);
        for (int i = 0; i < numRows; ++i) {
            FloatSparseVector vec = (FloatSparseVector)aggUser.getAggregatedValue(this.getRowAggregatorName(i));
            matrix.setRow(i, vec);
        }
        return matrix;
    }
}

