/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.aggregators.matrix.sparse;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.apache.giraph.aggregators.matrix.sparse.FloatSparseVector;

public class FloatSparseMatrix {
    private int numRows;
    private Int2ObjectOpenHashMap<FloatSparseVector> rows;

    public FloatSparseMatrix(int numRows) {
        this.numRows = numRows;
        this.rows = new Int2ObjectOpenHashMap(numRows);
        this.rows.defaultReturnValue(null);
    }

    public void initialize() {
        this.rows.clear();
        for (int i = 0; i < this.numRows; ++i) {
            this.setRow(i, new FloatSparseVector());
        }
    }

    public int getNumRows() {
        return this.numRows;
    }

    public float get(int i, int j) {
        return ((FloatSparseVector)this.rows.get(i)).get(j);
    }

    public void set(int i, int j, float v) {
        ((FloatSparseVector)this.rows.get(i)).set(j, v);
    }

    FloatSparseVector getRow(int i) {
        return (FloatSparseVector)this.rows.get(i);
    }

    void setRow(int i, FloatSparseVector vec) {
        this.rows.put(i, (Object)vec);
    }
}

