/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.aggregators.matrix.sparse;

import it.unimi.dsi.fastutil.ints.Int2DoubleMap;
import it.unimi.dsi.fastutil.ints.Int2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public class DoubleSparseVector
implements Writable {
    private Int2DoubleOpenHashMap entries = null;

    public DoubleSparseVector() {
        this.initialize(16);
    }

    public DoubleSparseVector(int size) {
        this.initialize(size);
    }

    private void initialize(int size) {
        this.entries = new Int2DoubleOpenHashMap(size);
        this.entries.defaultReturnValue(0.0);
    }

    public double get(int i) {
        return this.entries.get(i);
    }

    public void set(int i, double value) {
        this.entries.put(i, value);
    }

    public void clear() {
        this.entries.clear();
    }

    public void add(DoubleSparseVector other) {
        ObjectIterator iter = other.entries.int2DoubleEntrySet().fastIterator();
        while (iter.hasNext()) {
            Int2DoubleMap.Entry entry = (Int2DoubleMap.Entry)iter.next();
            this.entries.addTo(entry.getIntKey(), entry.getDoubleValue());
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.entries.size());
        ObjectIterator iter = this.entries.int2DoubleEntrySet().fastIterator();
        while (iter.hasNext()) {
            Int2DoubleMap.Entry entry = (Int2DoubleMap.Entry)iter.next();
            out.writeInt(entry.getIntKey());
            out.writeDouble(entry.getDoubleValue());
        }
    }

    public void readFields(DataInput in) throws IOException {
        int size = in.readInt();
        this.initialize(size);
        for (int i = 0; i < size; ++i) {
            int row = in.readInt();
            double value = in.readDouble();
            this.entries.put(row, value);
        }
    }
}

