/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.aggregators.matrix.sparse;

import org.apache.giraph.aggregators.AggregatorUsage;
import org.apache.giraph.aggregators.matrix.MatrixSumAggregator;
import org.apache.giraph.aggregators.matrix.sparse.DoubleSparseMatrix;
import org.apache.giraph.aggregators.matrix.sparse.DoubleSparseVector;
import org.apache.giraph.aggregators.matrix.sparse.DoubleSparseVectorSumAggregator;
import org.apache.giraph.master.MasterAggregatorUsage;
import org.apache.giraph.worker.WorkerAggregatorUsage;

public class DoubleSparseMatrixSumAggregator
extends MatrixSumAggregator {
    private DoubleSparseVector singletonVector = new DoubleSparseVector();

    public DoubleSparseMatrixSumAggregator(String name) {
        super(name);
    }

    public void register(int numRows, MasterAggregatorUsage master) throws InstantiationException, IllegalAccessException {
        for (int i = 0; i < numRows; ++i) {
            master.registerAggregator(this.getRowAggregatorName(i), DoubleSparseVectorSumAggregator.class);
        }
    }

    public void aggregate(int i, int j, double v, WorkerAggregatorUsage worker) {
        this.singletonVector.clear();
        this.singletonVector.set(j, v);
        worker.aggregate(this.getRowAggregatorName(i), this.singletonVector);
    }

    public void setMatrix(DoubleSparseMatrix matrix, MasterAggregatorUsage master) {
        int numRows = matrix.getNumRows();
        for (int i = 0; i < numRows; ++i) {
            master.setAggregatedValue(this.getRowAggregatorName(i), matrix.getRow(i));
        }
    }

    public DoubleSparseMatrix getMatrix(int numRows, AggregatorUsage aggUser) {
        DoubleSparseMatrix matrix = new DoubleSparseMatrix(numRows);
        for (int i = 0; i < numRows; ++i) {
            DoubleSparseVector vec = (DoubleSparseVector)aggUser.getAggregatedValue(this.getRowAggregatorName(i));
            matrix.setRow(i, vec);
        }
        return matrix;
    }
}

