/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.aggregators.matrix.sparse;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.apache.giraph.aggregators.matrix.sparse.DoubleSparseVector;

public class DoubleSparseMatrix {
    private int numRows;
    private Int2ObjectOpenHashMap<DoubleSparseVector> rows;

    public DoubleSparseMatrix(int numRows) {
        this.numRows = numRows;
        this.rows = new Int2ObjectOpenHashMap(numRows);
        this.rows.defaultReturnValue(null);
    }

    public void initialize() {
        this.rows.clear();
        for (int i = 0; i < this.numRows; ++i) {
            this.setRow(i, new DoubleSparseVector());
        }
    }

    public int getNumRows() {
        return this.numRows;
    }

    public double get(int i, int j) {
        return ((DoubleSparseVector)this.rows.get(i)).get(j);
    }

    public void set(int i, int j, double v) {
        ((DoubleSparseVector)this.rows.get(i)).set(j, v);
    }

    DoubleSparseVector getRow(int i) {
        return (DoubleSparseVector)this.rows.get(i);
    }

    void setRow(int i, DoubleSparseVector vec) {
        this.rows.put(i, (Object)vec);
    }
}

