/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.aggregators.matrix.dense;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public class LongDenseVector
implements Writable {
    private final LongArrayList entries = new LongArrayList();
    private boolean isSingleton = false;
    private int singletonIndex;
    private long singletonValue;

    public LongDenseVector() {
    }

    public LongDenseVector(int size) {
        this.ensureCapacity(size);
    }

    public void setSingleton(int index, long value) {
        this.isSingleton = true;
        this.singletonIndex = index;
        this.singletonValue = value;
    }

    public int getSingletonIndex() {
        return this.singletonIndex;
    }

    public long getSingletonValue() {
        return this.singletonValue;
    }

    public long get(int i) {
        if (i >= this.entries.size()) {
            return 0L;
        }
        return this.entries.getLong(i);
    }

    public void set(int i, long value) {
        this.entries.set(i, value);
    }

    public void add(LongDenseVector other) {
        if (this.isSingleton) {
            throw new RuntimeException("Cannot add to singleton vector");
        }
        if (other.isSingleton) {
            this.ensureCapacity(other.singletonIndex + 1);
            this.entries.set(other.singletonIndex, this.entries.getLong(other.singletonIndex) + other.singletonValue);
        } else {
            this.ensureCapacity(other.entries.size());
            for (int i = 0; i < other.entries.size(); ++i) {
                this.entries.set(i, this.entries.getLong(i) + other.entries.getLong(i));
            }
        }
    }

    private void ensureCapacity(int size) {
        if (this.entries.size() < size) {
            this.entries.size(size);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.isSingleton);
        if (this.isSingleton) {
            out.writeInt(this.singletonIndex);
            out.writeLong(this.singletonValue);
        } else {
            out.writeInt(this.entries.size());
            for (int i = 0; i < this.entries.size(); ++i) {
                out.writeLong(this.entries.getLong(i));
            }
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.isSingleton = in.readBoolean();
        if (this.isSingleton) {
            this.singletonIndex = in.readInt();
            this.singletonValue = in.readLong();
        } else {
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                this.entries.add(in.readLong());
            }
        }
    }
}

