/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.aggregators.matrix.dense;

import org.apache.giraph.aggregators.AggregatorUsage;
import org.apache.giraph.aggregators.matrix.MatrixSumAggregator;
import org.apache.giraph.aggregators.matrix.dense.LongDenseMatrix;
import org.apache.giraph.aggregators.matrix.dense.LongDenseVector;
import org.apache.giraph.aggregators.matrix.dense.LongDenseVectorSumAggregator;
import org.apache.giraph.master.MasterAggregatorUsage;
import org.apache.giraph.worker.WorkerAggregatorUsage;

public class LongDenseMatrixSumAggregator
extends MatrixSumAggregator {
    private LongDenseVector singletonVector = new LongDenseVector();

    public LongDenseMatrixSumAggregator(String name) {
        super(name);
    }

    public void register(int numRows, MasterAggregatorUsage master) throws InstantiationException, IllegalAccessException {
        for (int i = 0; i < numRows; ++i) {
            boolean success = master.registerAggregator(this.getRowAggregatorName(i), LongDenseVectorSumAggregator.class);
            if (success) continue;
            throw new RuntimeException("Aggregator already registered");
        }
    }

    public void aggregate(int i, int j, long v, WorkerAggregatorUsage worker) {
        this.singletonVector.setSingleton(j, v);
        worker.aggregate(this.getRowAggregatorName(i), this.singletonVector);
    }

    public void setMatrix(LongDenseMatrix matrix, MasterAggregatorUsage master) {
        int numRows = matrix.getNumRows();
        for (int i = 0; i < numRows; ++i) {
            master.setAggregatedValue(this.getRowAggregatorName(i), matrix.getRow(i));
        }
    }

    public LongDenseMatrix getMatrix(int numRows, AggregatorUsage aggUser) {
        LongDenseMatrix matrix = new LongDenseMatrix(numRows, 1);
        for (int i = 0; i < numRows; ++i) {
            LongDenseVector vec = (LongDenseVector)aggUser.getAggregatedValue(this.getRowAggregatorName(i));
            matrix.addRow(vec);
        }
        return matrix;
    }
}

