/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.aggregators.matrix.dense;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public class IntDenseVector
implements Writable {
    private final IntArrayList entries = new IntArrayList();
    private boolean isSingleton = false;
    private int singletonIndex;
    private int singletonValue;

    public IntDenseVector() {
    }

    public IntDenseVector(int size) {
        this.ensureCapacity(size);
    }

    public void setSingleton(int index, int value) {
        this.isSingleton = true;
        this.singletonIndex = index;
        this.singletonValue = value;
    }

    public int getSingletonIndex() {
        return this.singletonIndex;
    }

    public int getSingletonValue() {
        return this.singletonValue;
    }

    public int get(int i) {
        if (i >= this.entries.size()) {
            return 0;
        }
        return this.entries.getInt(i);
    }

    public void set(int i, int value) {
        this.entries.set(i, value);
    }

    public void add(IntDenseVector other) {
        if (this.isSingleton) {
            throw new RuntimeException("Cannot add to singleton vector");
        }
        if (other.isSingleton) {
            this.ensureCapacity(other.singletonIndex + 1);
            this.entries.set(other.singletonIndex, this.entries.getInt(other.singletonIndex) + other.singletonValue);
        } else {
            this.ensureCapacity(other.entries.size());
            for (int i = 0; i < other.entries.size(); ++i) {
                this.entries.set(i, this.entries.getInt(i) + other.entries.getInt(i));
            }
        }
    }

    private void ensureCapacity(int size) {
        if (this.entries.size() < size) {
            this.entries.size(size);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.isSingleton);
        if (this.isSingleton) {
            out.writeInt(this.singletonIndex);
            out.writeInt(this.singletonValue);
        } else {
            out.writeInt(this.entries.size());
            for (int i = 0; i < this.entries.size(); ++i) {
                out.writeInt(this.entries.getInt(i));
            }
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.isSingleton = in.readBoolean();
        if (this.isSingleton) {
            this.singletonIndex = in.readInt();
            this.singletonValue = in.readInt();
        } else {
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                this.entries.add(in.readInt());
            }
        }
    }
}

