/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.aggregators.matrix.dense;

import org.apache.giraph.aggregators.AggregatorUsage;
import org.apache.giraph.aggregators.matrix.MatrixSumAggregator;
import org.apache.giraph.aggregators.matrix.dense.IntDenseMatrix;
import org.apache.giraph.aggregators.matrix.dense.IntDenseVector;
import org.apache.giraph.aggregators.matrix.dense.IntDenseVectorSumAggregator;
import org.apache.giraph.master.MasterAggregatorUsage;
import org.apache.giraph.worker.WorkerAggregatorUsage;

public class IntDenseMatrixSumAggregator
extends MatrixSumAggregator {
    private IntDenseVector singletonVector = new IntDenseVector();

    public IntDenseMatrixSumAggregator(String name) {
        super(name);
    }

    public void register(int numRows, MasterAggregatorUsage master) throws InstantiationException, IllegalAccessException {
        for (int i = 0; i < numRows; ++i) {
            boolean success = master.registerAggregator(this.getRowAggregatorName(i), IntDenseVectorSumAggregator.class);
            if (success) continue;
            throw new RuntimeException("Aggregator already registered");
        }
    }

    public void aggregate(int i, int j, int v, WorkerAggregatorUsage worker) {
        this.singletonVector.setSingleton(j, v);
        worker.aggregate(this.getRowAggregatorName(i), this.singletonVector);
    }

    public void setMatrix(IntDenseMatrix matrix, MasterAggregatorUsage master) {
        int numRows = matrix.getNumRows();
        for (int i = 0; i < numRows; ++i) {
            master.setAggregatedValue(this.getRowAggregatorName(i), matrix.getRow(i));
        }
    }

    public IntDenseMatrix getMatrix(int numRows, AggregatorUsage aggUser) {
        IntDenseMatrix matrix = new IntDenseMatrix(numRows, 1);
        for (int i = 0; i < numRows; ++i) {
            IntDenseVector vec = (IntDenseVector)aggUser.getAggregatedValue(this.getRowAggregatorName(i));
            matrix.addRow(vec);
        }
        return matrix;
    }
}

