/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.aggregators.matrix.dense;

import it.unimi.dsi.fastutil.floats.FloatArrayList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public class FloatDenseVector
implements Writable {
    private final FloatArrayList entries = new FloatArrayList();
    private boolean isSingleton = false;
    private int singletonIndex;
    private float singletonValue;

    public FloatDenseVector() {
    }

    public FloatDenseVector(int size) {
        this.ensureCapacity(size);
    }

    public void setSingleton(int index, float value) {
        this.isSingleton = true;
        this.singletonIndex = index;
        this.singletonValue = value;
    }

    public int getSingletonIndex() {
        return this.singletonIndex;
    }

    public float getSingletonValue() {
        return this.singletonValue;
    }

    public float get(int i) {
        if (i >= this.entries.size()) {
            return 0.0f;
        }
        return this.entries.getFloat(i);
    }

    public void set(int i, float value) {
        this.entries.set(i, value);
    }

    public void add(FloatDenseVector other) {
        if (this.isSingleton) {
            throw new RuntimeException("Cannot add to singleton vector");
        }
        if (other.isSingleton) {
            this.ensureCapacity(other.singletonIndex + 1);
            this.entries.set(other.singletonIndex, this.entries.getFloat(other.singletonIndex) + other.singletonValue);
        } else {
            this.ensureCapacity(other.entries.size());
            for (int i = 0; i < other.entries.size(); ++i) {
                this.entries.set(i, this.entries.getFloat(i) + other.entries.getFloat(i));
            }
        }
    }

    private void ensureCapacity(int size) {
        if (this.entries.size() < size) {
            this.entries.size(size);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.isSingleton);
        if (this.isSingleton) {
            out.writeInt(this.singletonIndex);
            out.writeFloat(this.singletonValue);
        } else {
            out.writeInt(this.entries.size());
            for (int i = 0; i < this.entries.size(); ++i) {
                out.writeFloat(this.entries.getFloat(i));
            }
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.isSingleton = in.readBoolean();
        if (this.isSingleton) {
            this.singletonIndex = in.readInt();
            this.singletonValue = in.readFloat();
        } else {
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                this.entries.add(in.readFloat());
            }
        }
    }
}

