/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.aggregators.matrix.dense;

import org.apache.giraph.aggregators.AggregatorUsage;
import org.apache.giraph.aggregators.matrix.MatrixSumAggregator;
import org.apache.giraph.aggregators.matrix.dense.FloatDenseMatrix;
import org.apache.giraph.aggregators.matrix.dense.FloatDenseVector;
import org.apache.giraph.aggregators.matrix.dense.FloatDenseVectorSumAggregator;
import org.apache.giraph.master.MasterAggregatorUsage;
import org.apache.giraph.worker.WorkerAggregatorUsage;

public class FloatDenseMatrixSumAggregator
extends MatrixSumAggregator {
    private FloatDenseVector singletonVector = new FloatDenseVector();

    public FloatDenseMatrixSumAggregator(String name) {
        super(name);
    }

    public void register(int numRows, MasterAggregatorUsage master) throws InstantiationException, IllegalAccessException {
        for (int i = 0; i < numRows; ++i) {
            boolean success = master.registerAggregator(this.getRowAggregatorName(i), FloatDenseVectorSumAggregator.class);
            if (success) continue;
            throw new RuntimeException("Aggregator already registered");
        }
    }

    public void aggregate(int i, int j, float v, WorkerAggregatorUsage worker) {
        this.singletonVector.setSingleton(j, v);
        worker.aggregate(this.getRowAggregatorName(i), this.singletonVector);
    }

    public void setMatrix(FloatDenseMatrix matrix, MasterAggregatorUsage master) {
        int numRows = matrix.getNumRows();
        for (int i = 0; i < numRows; ++i) {
            master.setAggregatedValue(this.getRowAggregatorName(i), matrix.getRow(i));
        }
    }

    public FloatDenseMatrix getMatrix(int numRows, AggregatorUsage aggUser) {
        FloatDenseMatrix matrix = new FloatDenseMatrix(numRows, 1);
        for (int i = 0; i < numRows; ++i) {
            FloatDenseVector vec = (FloatDenseVector)aggUser.getAggregatedValue(this.getRowAggregatorName(i));
            matrix.addRow(vec);
        }
        return matrix;
    }
}

