/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.aggregators.matrix.dense;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public class DoubleDenseVector
implements Writable {
    private final DoubleArrayList entries = new DoubleArrayList();
    private boolean isSingleton = false;
    private int singletonIndex;
    private double singletonValue;

    public DoubleDenseVector() {
    }

    public DoubleDenseVector(int size) {
        this.ensureCapacity(size);
    }

    public void setSingleton(int index, double value) {
        this.isSingleton = true;
        this.singletonIndex = index;
        this.singletonValue = value;
    }

    public int getSingletonIndex() {
        return this.singletonIndex;
    }

    public double getSingletonValue() {
        return this.singletonValue;
    }

    public double get(int i) {
        if (i >= this.entries.size()) {
            return 0.0;
        }
        return this.entries.getDouble(i);
    }

    public void set(int i, double value) {
        this.entries.set(i, value);
    }

    public void add(DoubleDenseVector other) {
        if (this.isSingleton) {
            throw new RuntimeException("Cannot add to singleton vector");
        }
        if (other.isSingleton) {
            this.ensureCapacity(other.singletonIndex + 1);
            this.entries.set(other.singletonIndex, this.entries.getDouble(other.singletonIndex) + other.singletonValue);
        } else {
            this.ensureCapacity(other.entries.size());
            for (int i = 0; i < other.entries.size(); ++i) {
                this.entries.set(i, this.entries.getDouble(i) + other.entries.getDouble(i));
            }
        }
    }

    private void ensureCapacity(int size) {
        if (this.entries.size() < size) {
            this.entries.size(size);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.isSingleton);
        if (this.isSingleton) {
            out.writeInt(this.singletonIndex);
            out.writeDouble(this.singletonValue);
        } else {
            out.writeInt(this.entries.size());
            for (int i = 0; i < this.entries.size(); ++i) {
                out.writeDouble(this.entries.getDouble(i));
            }
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.isSingleton = in.readBoolean();
        if (this.isSingleton) {
            this.singletonIndex = in.readInt();
            this.singletonValue = in.readDouble();
        } else {
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                this.entries.add(in.readDouble());
            }
        }
    }
}

