/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.aggregators.matrix.dense;

import org.apache.giraph.aggregators.AggregatorUsage;
import org.apache.giraph.aggregators.matrix.MatrixSumAggregator;
import org.apache.giraph.aggregators.matrix.dense.DoubleDenseMatrix;
import org.apache.giraph.aggregators.matrix.dense.DoubleDenseVector;
import org.apache.giraph.aggregators.matrix.dense.DoubleDenseVectorSumAggregator;
import org.apache.giraph.master.MasterAggregatorUsage;
import org.apache.giraph.worker.WorkerAggregatorUsage;

public class DoubleDenseMatrixSumAggregator
extends MatrixSumAggregator {
    private DoubleDenseVector singletonVector = new DoubleDenseVector();

    public DoubleDenseMatrixSumAggregator(String name) {
        super(name);
    }

    public void register(int numRows, MasterAggregatorUsage master) throws InstantiationException, IllegalAccessException {
        for (int i = 0; i < numRows; ++i) {
            boolean success = master.registerAggregator(this.getRowAggregatorName(i), DoubleDenseVectorSumAggregator.class);
            if (success) continue;
            throw new RuntimeException("Aggregator already registered");
        }
    }

    public void aggregate(int i, int j, double v, WorkerAggregatorUsage worker) {
        this.singletonVector.setSingleton(j, v);
        worker.aggregate(this.getRowAggregatorName(i), this.singletonVector);
    }

    public void setMatrix(DoubleDenseMatrix matrix, MasterAggregatorUsage master) {
        int numRows = matrix.getNumRows();
        for (int i = 0; i < numRows; ++i) {
            master.setAggregatedValue(this.getRowAggregatorName(i), matrix.getRow(i));
        }
    }

    public DoubleDenseMatrix getMatrix(int numRows, AggregatorUsage aggUser) {
        DoubleDenseMatrix matrix = new DoubleDenseMatrix(numRows, 1);
        for (int i = 0; i < numRows; ++i) {
            DoubleDenseVector vec = (DoubleDenseVector)aggUser.getAggregatedValue(this.getRowAggregatorName(i));
            matrix.addRow(vec);
        }
        return matrix;
    }
}

