/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.aggregators.matrix.dense;

import java.util.ArrayList;
import org.apache.giraph.aggregators.matrix.dense.DoubleDenseVector;

public class DoubleDenseMatrix {
    private int numRows;
    private int numColumns;
    private ArrayList<DoubleDenseVector> rows = null;

    public DoubleDenseMatrix(int size) {
        this(size, size);
    }

    public DoubleDenseMatrix(int numRows, int numColumns) {
        this.numRows = numRows;
        this.numColumns = numColumns;
        this.rows = new ArrayList();
    }

    public void initialize() {
        this.rows.clear();
        for (int i = 0; i < this.numRows; ++i) {
            this.rows.add(new DoubleDenseVector(this.numColumns));
        }
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public double get(int i, int j) {
        return this.rows.get(i).get(j);
    }

    public void set(int i, int j, double v) {
        this.rows.get(i).set(j, v);
    }

    DoubleDenseVector getRow(int i) {
        return this.rows.get(i);
    }

    void addRow(DoubleDenseVector vec) {
        if (this.rows.size() >= this.numRows) {
            throw new RuntimeException("Cannot add more rows!");
        }
        this.rows.add(vec);
    }
}

