/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.aggregators;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.util.Map;
import org.apache.giraph.aggregators.AggregatorWriter;
import org.apache.giraph.conf.DefaultImmutableClassesGiraphConfigurable;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;

public class TextAggregatorWriter
extends DefaultImmutableClassesGiraphConfigurable
implements AggregatorWriter {
    public static final String FILENAME = "giraph.textAggregatorWriter.filename";
    public static final int NEVER = 0;
    public static final int AT_THE_END = -1;
    public static final int ALWAYS = 1;
    public static final String FREQUENCY = "giraph.textAggregatorWriter.frequency";
    private static final String DEFAULT_FILENAME = "aggregatorValues";
    protected FSDataOutputStream output;
    private int frequency;

    @Override
    public void initialize(Mapper.Context context, long attempt) throws IOException {
        this.frequency = this.getConf().getInt(FREQUENCY, 0);
        String filename = this.getConf().get(FILENAME, DEFAULT_FILENAME);
        if (this.frequency != 0) {
            Path p = new Path(filename + "_" + attempt);
            FileSystem fs = FileSystem.get(this.getConf());
            if (fs.exists(p)) {
                throw new RuntimeException("aggregatorWriter file already exists: " + p.getName());
            }
            this.output = fs.create(p);
        }
    }

    @Override
    public void writeAggregator(Iterable<Map.Entry<String, Writable>> aggregatorMap, long superstep) throws IOException {
        if (this.shouldWrite(superstep)) {
            for (Map.Entry<String, Writable> entry : aggregatorMap) {
                byte[] bytes = this.aggregatorToString(entry.getKey(), entry.getValue(), superstep).getBytes(Charsets.UTF_8);
                this.output.write(bytes, 0, bytes.length);
            }
            this.output.flush();
        }
    }

    protected String aggregatorToString(String aggregatorName, Writable value, long superstep) {
        return "superstep=" + superstep + "\t" + aggregatorName + "=" + value + "\n";
    }

    private boolean shouldWrite(long superstep) {
        return this.frequency == -1 && superstep == -1L || this.frequency != 0 && superstep % (long)this.frequency == 0L;
    }

    @Override
    public void close() throws IOException {
        if (this.output != null) {
            this.output.close();
        }
    }
}

