/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph;

import java.net.URI;
import org.apache.commons.cli.CommandLine;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.job.GiraphJob;
import org.apache.giraph.utils.ConfigurationUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class GiraphRunner
implements Tool {
    private static final Logger LOG;
    private Configuration conf;

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public int run(String[] args) throws Exception {
        GiraphConfiguration giraphConf;
        CommandLine cmd;
        if (null == this.getConf()) {
            this.conf = new Configuration();
        }
        if (null == (cmd = ConfigurationUtils.parseArgs(giraphConf = new GiraphConfiguration(this.getConf()), args))) {
            return 0;
        }
        String vertexClassName = args[0];
        String jobName = "Giraph: " + vertexClassName;
        GiraphJob job = new GiraphJob(giraphConf, jobName);
        this.prepareHadoopMRJob(job, cmd);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Attempting to run Vertex: " + vertexClassName));
        }
        boolean verbose = !cmd.hasOption('q');
        return job.run(verbose) ? 0 : -1;
    }

    private void prepareHadoopMRJob(GiraphJob job, CommandLine cmd) throws Exception {
        if ((cmd.hasOption("vof") || cmd.hasOption("eof")) && cmd.hasOption("op")) {
            FileOutputFormat.setOutputPath((Job)job.getInternalJob(), (Path)new Path(cmd.getOptionValue("op")));
        }
        if (cmd.hasOption("cf")) {
            DistributedCache.addCacheFile((URI)new URI(cmd.getOptionValue("cf")), (Configuration)job.getConfiguration());
        }
    }

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run((Tool)new GiraphRunner(), (String[])args));
    }

    static {
        Configuration.addDefaultResource((String)"giraph-site.xml");
        LOG = Logger.getLogger(GiraphRunner.class);
    }
}

