/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.table;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.OID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ColumnMetaDataContainer;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierType;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingConsumer;
import org.datanucleus.store.mapped.mapping.OIDMapping;
import org.datanucleus.store.mapped.mapping.PersistableMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.TableImpl;
import org.datanucleus.store.valuegenerator.AbstractGenerator;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class AbstractClassTable
extends TableImpl {
    protected Map<AbstractMemberMetaData, JavaTypeMapping> memberMappingsMap = new HashMap<AbstractMemberMetaData, JavaTypeMapping>();
    protected JavaTypeMapping datastoreIDMapping;
    protected JavaTypeMapping[] pkMappings;
    protected JavaTypeMapping idMapping;
    protected JavaTypeMapping versionMapping;
    protected VersionMetaData versionMetaData;
    protected DiscriminatorMetaData discriminatorMetaData;
    protected JavaTypeMapping discriminatorMapping;
    protected int highestMemberNumber = 0;

    public AbstractClassTable(DatastoreIdentifier tableName, RDBMSStoreManager storeMgr) {
        super(tableName, storeMgr);
    }

    public DatastoreContainerObject getPrimaryDatastoreContainerObject() {
        return this;
    }

    protected abstract void initializePK(ClassLoaderResolver var1);

    public boolean managesMember(String memberName) {
        if (memberName == null) {
            return false;
        }
        return this.getMappingForMemberName(memberName) != null;
    }

    protected JavaTypeMapping getMappingForMemberName(String memberName) {
        Set<AbstractMemberMetaData> fields = this.memberMappingsMap.keySet();
        for (AbstractMemberMetaData mmd : fields) {
            if (!mmd.getFullFieldName().equals(memberName)) continue;
            return this.memberMappingsMap.get(mmd);
        }
        return null;
    }

    public boolean managesMapping(JavaTypeMapping mapping) {
        Collection<JavaTypeMapping> mappings = this.memberMappingsMap.values();
        if (mappings.contains(mapping)) {
            return true;
        }
        if (mapping == this.discriminatorMapping) {
            return true;
        }
        if (mapping == this.versionMapping) {
            return true;
        }
        if (mapping == this.datastoreIDMapping) {
            return true;
        }
        return mapping == this.idMapping;
    }

    final void addApplicationIdUsingClassTableId(ColumnMetaDataContainer columnContainer, DatastoreClass refTable, ClassLoaderResolver clr, AbstractClassMetaData cmd) {
        ColumnMetaData[] userdefinedCols = null;
        int nextUserdefinedCol = 0;
        if (columnContainer != null) {
            userdefinedCols = columnContainer.getColumnMetaData();
        }
        this.pkMappings = new JavaTypeMapping[cmd.getPKMemberPositions().length];
        for (int i = 0; i < cmd.getPKMemberPositions().length; ++i) {
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(cmd.getPKMemberPositions()[i]);
            JavaTypeMapping mapping = refTable.getMemberMapping(mmd);
            if (mapping == null) {
                throw new NucleusUserException("Cannot find mapping for field " + mmd.getFullFieldName() + " in table " + refTable.toString() + " " + StringUtils.objectArrayToString((Object[])refTable.getDatastoreFields()));
            }
            JavaTypeMapping masterMapping = this.storeMgr.getMappingManager().getMapping(clr.classForName(mapping.getType()));
            masterMapping.setMemberMetaData(mmd);
            masterMapping.setDatastoreContainer((DatastoreContainerObject)this);
            this.pkMappings[i] = masterMapping;
            for (int j = 0; j < mapping.getNumberOfDatastoreMappings(); ++j) {
                JavaTypeMapping m = masterMapping;
                DatastoreField refColumn = mapping.getDatastoreMapping(j).getDatastoreField();
                if (mapping instanceof PersistableMapping) {
                    m = this.storeMgr.getMappingManager().getMapping(clr.classForName(refColumn.getJavaTypeMapping().getType()));
                    ((PersistableMapping)masterMapping).addJavaTypeMapping(m);
                }
                ColumnMetaData userdefinedColumn = null;
                if (userdefinedCols != null) {
                    for (int k = 0; k < userdefinedCols.length; ++k) {
                        if (!refColumn.getIdentifier().toString().equals(userdefinedCols[k].getTarget())) continue;
                        userdefinedColumn = userdefinedCols[k];
                        break;
                    }
                    if (userdefinedColumn == null && nextUserdefinedCol < userdefinedCols.length) {
                        userdefinedColumn = userdefinedCols[nextUserdefinedCol++];
                    }
                }
                DatastoreField idColumn = null;
                idColumn = userdefinedColumn != null ? this.addDatastoreField(refColumn.getStoredJavaType(), this.storeMgr.getIdentifierFactory().newIdentifier(IdentifierType.COLUMN, userdefinedColumn.getName()), m, (MetaData)refColumn.getColumnMetaData()) : this.addDatastoreField(refColumn.getStoredJavaType(), refColumn.getIdentifier(), m, (MetaData)refColumn.getColumnMetaData());
                if (mapping != null && mapping.getDatastoreMapping(j).getDatastoreField().getColumnMetaData() != null) {
                    refColumn.copyConfigurationTo(idColumn);
                }
                idColumn.setAsPrimaryKey();
                this.getStoreManager().getMappingManager().createDatastoreMapping(m, idColumn, refColumn.getJavaTypeMapping().getType());
            }
            int absoluteFieldNumber = mmd.getAbsoluteFieldNumber();
            if (absoluteFieldNumber <= this.highestMemberNumber) continue;
            this.highestMemberNumber = absoluteFieldNumber;
        }
    }

    void addDatastoreId(ColumnMetaDataContainer columnContainer, DatastoreClass refTable, AbstractClassMetaData cmd) {
        this.datastoreIDMapping = new OIDMapping();
        this.datastoreIDMapping.setDatastoreContainer((DatastoreContainerObject)this);
        this.datastoreIDMapping.initialize((MappedStoreManager)this.storeMgr, cmd.getFullClassName());
        ColumnMetaData colmd = null;
        colmd = columnContainer == null ? new ColumnMetaData() : (columnContainer.getColumnMetaData().length < 1 ? new ColumnMetaData() : columnContainer.getColumnMetaData()[0]);
        if (colmd.getName() == null) {
            if (refTable != null) {
                colmd.setName(this.storeMgr.getIdentifierFactory().newDatastoreFieldIdentifier(refTable.getIdentifier().getIdentifierName(), this.storeMgr.getOMFContext().getTypeManager().isDefaultEmbeddedType(OID.class), 1).getIdentifierName());
            } else {
                colmd.setName(this.storeMgr.getIdentifierFactory().newDatastoreFieldIdentifier(this.identifier.getIdentifierName(), this.storeMgr.getOMFContext().getTypeManager().isDefaultEmbeddedType(OID.class), 0).getIdentifierName());
            }
        }
        Column idColumn = (Column)this.addDatastoreField(OID.class.getName(), this.storeMgr.getIdentifierFactory().newIdentifier(IdentifierType.COLUMN, colmd.getName()), this.datastoreIDMapping, (MetaData)colmd);
        idColumn.setAsPrimaryKey();
        String strategyName = cmd.getIdentityMetaData().getValueStrategy().toString();
        if (cmd.getIdentityMetaData().getValueStrategy().equals((Object)IdentityStrategy.CUSTOM)) {
            strategyName = cmd.getIdentityMetaData().getValueStrategy().getCustomName();
        }
        Class valueGeneratedType = Long.class;
        try {
            AbstractGenerator generator = (AbstractGenerator)this.storeMgr.getOMFContext().getPluginManager().createExecutableExtension("org.datanucleus.store_valuegenerator", new String[]{"name", "unique"}, new String[]{strategyName, "true"}, "class-name", new Class[]{String.class, Properties.class}, new Object[]{null, null});
            if (generator == null) {
                generator = (AbstractGenerator)this.storeMgr.getOMFContext().getPluginManager().createExecutableExtension("org.datanucleus.store_valuegenerator", new String[]{"name", "datastore"}, new String[]{strategyName, this.storeMgr.getStoreManagerKey()}, "class-name", new Class[]{String.class, Properties.class}, new Object[]{null, null});
            }
            if (generator != null) {
                valueGeneratedType = (Class)generator.getClass().getMethod("getStorageClass", new Class[0]).invoke(null, new Object[0]);
            }
        }
        catch (Exception e) {
            NucleusLogger.VALUEGENERATION.warn((Object)("Error retrieving storage class for value-generator " + strategyName + " " + e.getMessage()));
        }
        this.storeMgr.getMappingManager().createDatastoreMapping(this.datastoreIDMapping, (DatastoreField)idColumn, valueGeneratedType.getName());
        if (this.isObjectIdDatastoreAttributed() && this instanceof DatastoreClass && ((DatastoreClass)this).isBaseDatastoreClass()) {
            idColumn.setIdentity(true);
        }
        if (idColumn.isIdentity() && !this.dba.supportsOption("IdentityColumns")) {
            throw new NucleusException(LOCALISER.msg("057020", (Object)cmd.getFullClassName(), (Object)"datastore-identity")).setFatal();
        }
    }

    protected void addMemberMapping(JavaTypeMapping fieldMapping) {
        AbstractMemberMetaData mmd = fieldMapping.getMemberMetaData();
        if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
            StringBuffer columnsStr = new StringBuffer();
            for (int i = 0; i < fieldMapping.getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    columnsStr.append(",");
                }
                columnsStr.append(fieldMapping.getDatastoreMapping(i).getDatastoreField());
            }
            if (fieldMapping.getNumberOfDatastoreMappings() == 0) {
                columnsStr.append("[none]");
            }
            StringBuffer datastoreMappingTypes = new StringBuffer();
            for (int i = 0; i < fieldMapping.getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    datastoreMappingTypes.append(',');
                }
                datastoreMappingTypes.append(fieldMapping.getDatastoreMapping(i).getClass().getName());
            }
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("057010", (Object)mmd.getFullFieldName(), (Object)columnsStr.toString(), (Object)fieldMapping.getClass().getName(), (Object)datastoreMappingTypes.toString()));
        }
        this.memberMappingsMap.put(mmd, fieldMapping);
        int absoluteFieldNumber = mmd.getAbsoluteFieldNumber();
        if (absoluteFieldNumber > this.highestMemberNumber) {
            this.highestMemberNumber = absoluteFieldNumber;
        }
    }

    public abstract IdentityType getIdentityType();

    public abstract boolean isObjectIdDatastoreAttributed();

    public JavaTypeMapping getDatastoreObjectIdMapping() {
        this.assertIsInitialized();
        return this.datastoreIDMapping;
    }

    public JavaTypeMapping getVersionMapping(boolean allowSuperclasses) {
        return this.versionMapping;
    }

    public JavaTypeMapping getDiscriminatorMapping(boolean allowSuperclasses) {
        return this.discriminatorMapping;
    }

    public final void provideDatastoreIdMappings(MappingConsumer consumer) {
        consumer.preConsumeMapping(this.highestMemberNumber + 1);
        if (this.getIdentityType() == IdentityType.DATASTORE) {
            consumer.consumeMapping(this.getDatastoreObjectIdMapping(), 2);
        }
    }

    public abstract void providePrimaryKeyMappings(MappingConsumer var1);

    public final void provideNonPrimaryKeyMappings(MappingConsumer consumer) {
        consumer.preConsumeMapping(this.highestMemberNumber + 1);
        Set<AbstractMemberMetaData> fieldNumbersSet = this.memberMappingsMap.keySet();
        for (AbstractMemberMetaData mmd : fieldNumbersSet) {
            JavaTypeMapping memberMapping = this.memberMappingsMap.get(mmd);
            if (memberMapping == null || mmd.isPrimaryKey()) continue;
            consumer.consumeMapping(memberMapping, mmd);
        }
    }

    public void provideMappingsForMembers(MappingConsumer consumer, AbstractMemberMetaData[] mmds, boolean includeSecondaryTables) {
        consumer.preConsumeMapping(this.highestMemberNumber + 1);
        for (int i = 0; i < mmds.length; ++i) {
            JavaTypeMapping fieldMapping = this.memberMappingsMap.get(mmds[i]);
            if (fieldMapping == null || mmds[i].isPrimaryKey()) continue;
            consumer.consumeMapping(fieldMapping, mmds[i]);
        }
    }

    public final void provideVersionMappings(MappingConsumer consumer) {
        consumer.preConsumeMapping(this.highestMemberNumber + 1);
        if (this.getVersionMapping(false) != null) {
            consumer.consumeMapping(this.getVersionMapping(false), 1);
        }
    }

    public final void provideDiscriminatorMappings(MappingConsumer consumer) {
        consumer.preConsumeMapping(this.highestMemberNumber + 1);
        if (this.getDiscriminatorMapping(false) != null) {
            consumer.consumeMapping(this.getDiscriminatorMapping(false), 3);
        }
    }
}

