/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.pdk;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintStream;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.hadoop.hive.cli.CliDriver;
import org.apache.hive.pdk.HivePdkUnitTest;
import org.apache.hive.pdk.HivePdkUnitTests;

public class PluginTest
extends TestCase {
    private HivePdkUnitTest unitTest;

    private PluginTest(HivePdkUnitTest unitTest) {
        super(unitTest.query());
        this.unitTest = unitTest;
    }

    public void runTest() throws Exception {
        String output = PluginTest.runHive("-i", "metadata/add-jar.sql", "-e", this.unitTest.query());
        PluginTest.assertEquals((String)this.unitTest.result(), (String)output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String runHive(String ... args) throws Exception {
        String line;
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        ByteArrayOutputStream errBytes = new ByteArrayOutputStream();
        PrintStream outSaved = System.out;
        PrintStream errSaved = System.err;
        System.setOut(new PrintStream(outBytes, true));
        System.setErr(new PrintStream(errBytes, true));
        try {
            CliDriver.run((String[])args);
        }
        finally {
            System.setOut(outSaved);
            System.setErr(errSaved);
        }
        ByteArrayInputStream outBytesIn = new ByteArrayInputStream(outBytes.toByteArray());
        ByteArrayInputStream errBytesIn = new ByteArrayInputStream(errBytes.toByteArray());
        BufferedReader is = new BufferedReader(new InputStreamReader(outBytesIn));
        BufferedReader es = new BufferedReader(new InputStreamReader(errBytesIn));
        StringBuilder output = new StringBuilder();
        while ((line = is.readLine()) != null) {
            if (output.length() > 0) {
                output.append("\n");
            }
            output.append(line);
        }
        if (output.length() == 0) {
            output = new StringBuilder();
            while ((line = es.readLine()) != null) {
                output.append("\n");
                output.append(line);
            }
        }
        return output.toString();
    }

    public static Test suite() throws Exception {
        String classList = System.getProperty("hive.plugin.class.list");
        String[] classNames = classList.split(" ");
        TestSuite suite = new TestSuite("Plugin Tests");
        for (String className : classNames) {
            Class<?> c = Class.forName(className);
            HivePdkUnitTests tests = c.getAnnotation(HivePdkUnitTests.class);
            if (tests == null) continue;
            TestSuite classSuite = new TestSuite(c.getName());
            for (HivePdkUnitTest unitTest : tests.cases()) {
                classSuite.addTest((Test)new PluginTest(unitTest));
            }
            suite.addTest((Test)new PluginTestSetup(classSuite, tests));
        }
        return new PluginGlobalSetup((Test)suite);
    }

    public static void main(String[] args) throws Exception {
        TestRunner.run((Test)PluginTest.suite());
    }

    public static class PluginGlobalSetup
    extends TestSetup {
        private File testScriptDir = new File(System.getProperty("hive.plugin.root.dir"), "test");

        PluginGlobalSetup(Test test) {
            super(test);
        }

        protected void setUp() throws Exception {
            String result = PluginTest.runHive("-i", new File(this.testScriptDir, "cleanup.sql").toString(), "-i", "metadata/add-jar.sql", "-i", "metadata/class-registration.sql", "-f", new File(this.testScriptDir, "setup.sql").toString());
            if (result.length() > 0) {
                System.err.println("GLOBAL SETUP:  " + result);
            }
        }

        protected void tearDown() throws Exception {
            String result = PluginTest.runHive("-f", new File(this.testScriptDir, "cleanup.sql").toString());
            if (result.length() > 0) {
                System.err.println("GLOBAL TEARDOWN:  " + result);
            }
        }
    }

    public static class PluginTestSetup
    extends TestSetup {
        String name;
        HivePdkUnitTests unitTests;

        PluginTestSetup(TestSuite test, HivePdkUnitTests unitTests) {
            super((Test)test);
            this.name = test.getName();
            this.unitTests = unitTests;
        }

        protected void setUp() throws Exception {
            String result;
            String cleanup = this.unitTests.cleanup();
            String setup = this.unitTests.setup();
            if (cleanup == null) {
                cleanup = "";
            }
            if (setup == null) {
                setup = "";
            }
            if ((cleanup.length() > 0 || setup.length() > 0) && (result = PluginTest.runHive("-e", cleanup + "\n" + setup)).length() > 0) {
                System.err.println(this.name + " SETUP:  " + result);
            }
        }

        protected void tearDown() throws Exception {
            String result;
            String cleanup = this.unitTests.cleanup();
            if (cleanup != null && (result = PluginTest.runHive("-e", cleanup)).length() > 0) {
                System.err.println(this.name + " TEARDOWN:  " + result);
            }
        }
    }
}

