/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.guice;

import com.facebook.nifty.core.NettyServerConfig;
import com.facebook.nifty.core.ThriftServerDef;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.util.Providers;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;

public abstract class NiftyModule
extends AbstractModule {
    private boolean configBound = false;

    protected void configure() {
        this.configureNifty();
    }

    @Provides
    @Singleton
    public ChannelGroup getChannelGroup() {
        return new DefaultChannelGroup();
    }

    public NiftyModule useDefaultNettyServerConfig() {
        this.withNettyServerConfig(new Provider<NettyServerConfig>(){

            public NettyServerConfig get() {
                return NettyServerConfig.newBuilder().build();
            }
        });
        return this;
    }

    public NiftyModule withNettyServerConfig(Class<? extends Provider<NettyServerConfig>> providerClass) {
        if (!this.configBound) {
            this.binder().bind(NettyServerConfig.class).toProvider(providerClass);
            this.configBound = true;
            return this;
        }
        throw this.iae();
    }

    public NiftyModule withNettyServerConfig(Provider<NettyServerConfig> provider) {
        if (!this.configBound) {
            com.google.inject.Provider guiceProvider = Providers.guicify(provider);
            this.binder().bind(NettyServerConfig.class).toProvider(guiceProvider);
            this.configBound = true;
            return this;
        }
        throw this.iae();
    }

    protected abstract void configureNifty();

    protected NiftyBuilder bind() {
        return new NiftyBuilder();
    }

    private IllegalStateException iae() {
        return new IllegalStateException("Config already bound! Call useDefaultNettyServerConfig() or withNettyServerConfig() only once");
    }

    protected class NiftyBuilder {
        public void toInstance(ThriftServerDef def) {
            Multibinder.newSetBinder((Binder)NiftyModule.this.binder(), ThriftServerDef.class).addBinding().toInstance((Object)def);
        }

        public void toProvider(Class<? extends Provider<ThriftServerDef>> provider) {
            Multibinder.newSetBinder((Binder)NiftyModule.this.binder(), ThriftServerDef.class).addBinding().toProvider(provider).asEagerSingleton();
        }

        public void toProvider(Provider<? extends ThriftServerDef> provider) {
            com.google.inject.Provider guiceProvider = Providers.guicify(provider);
            Multibinder.newSetBinder((Binder)NiftyModule.this.binder(), ThriftServerDef.class).addBinding().toProvider(guiceProvider).asEagerSingleton();
        }

        public void toProvider(TypeLiteral<? extends Provider<? extends ThriftServerDef>> typeLiteral) {
            Multibinder.newSetBinder((Binder)NiftyModule.this.binder(), ThriftServerDef.class).addBinding().toProvider(typeLiteral).asEagerSingleton();
        }

        public void toProvider(Key<? extends Provider<? extends ThriftServerDef>> key) {
            Multibinder.newSetBinder((Binder)NiftyModule.this.binder(), ThriftServerDef.class).addBinding().toProvider(key).asEagerSingleton();
        }

        public void to(Class<? extends ThriftServerDef> clazz) {
            Multibinder.newSetBinder((Binder)NiftyModule.this.binder(), ThriftServerDef.class).addBinding().to(clazz).asEagerSingleton();
        }

        public void to(TypeLiteral<? extends ThriftServerDef> typeLiteral) {
            Multibinder.newSetBinder((Binder)NiftyModule.this.binder(), ThriftServerDef.class).addBinding().to(typeLiteral).asEagerSingleton();
        }

        public void to(Key<? extends ThriftServerDef> key) {
            Multibinder.newSetBinder((Binder)NiftyModule.this.binder(), ThriftServerDef.class).addBinding().to(key).asEagerSingleton();
        }
    }
}

