/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.duplex;

import com.facebook.nifty.duplex.TProtocolPair;
import com.facebook.nifty.duplex.TTransportPair;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransport;

public abstract class TDuplexProtocolFactory {
    public abstract TProtocolPair getProtocolPair(TTransportPair var1);

    public TProtocolFactory getInputProtocolFactory() {
        return new TProtocolFactory(){

            public TProtocol getProtocol(TTransport trans) {
                return TDuplexProtocolFactory.this.getProtocolPair(TTransportPair.fromSingleTransport(trans)).getInputProtocol();
            }
        };
    }

    public TProtocolFactory getOutputProtocolFactory() {
        return new TProtocolFactory(){

            public TProtocol getProtocol(TTransport trans) {
                return TDuplexProtocolFactory.this.getProtocolPair(TTransportPair.fromSingleTransport(trans)).getOutputProtocol();
            }
        };
    }

    public static TDuplexProtocolFactory fromSingleFactory(final TProtocolFactory protocolFactory) {
        return new TDuplexProtocolFactory(){

            @Override
            public TProtocolPair getProtocolPair(TTransportPair transportPair) {
                return TProtocolPair.fromSeparateProtocols(protocolFactory.getProtocol(transportPair.getInputTransport()), protocolFactory.getProtocol(transportPair.getOutputTransport()));
            }
        };
    }

    public static TDuplexProtocolFactory fromSeparateFactories(final TProtocolFactory inputProtocolFactory, final TProtocolFactory outputProtocolFactory) {
        return new TDuplexProtocolFactory(){

            @Override
            public TProtocolPair getProtocolPair(TTransportPair transportPair) {
                return TProtocolPair.fromSeparateProtocols(inputProtocolFactory.getProtocol(transportPair.getInputTransport()), outputProtocolFactory.getProtocol(transportPair.getOutputTransport()));
            }
        };
    }
}

