/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.core;

import com.facebook.nifty.core.ThriftMessage;
import com.facebook.nifty.core.ThriftTransportType;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;

public class TNiftyTransport
extends TTransport {
    private final Channel channel;
    private final ChannelBuffer in;
    private final ThriftTransportType thriftTransportType;
    private final ChannelBuffer out;
    private static final int DEFAULT_OUTPUT_BUFFER_SIZE = 1024;
    private final int initialReaderIndex;
    private final int initialBufferPosition;
    private int bufferPosition;
    private int bufferEnd;
    private final byte[] buffer;

    public TNiftyTransport(Channel channel, ChannelBuffer in, ThriftTransportType thriftTransportType) {
        this.channel = channel;
        this.in = in;
        this.thriftTransportType = thriftTransportType;
        this.out = ChannelBuffers.dynamicBuffer((int)1024);
        this.initialReaderIndex = in.readerIndex();
        if (!in.hasArray()) {
            this.buffer = null;
            this.bufferPosition = 0;
            this.bufferEnd = -1;
            this.initialBufferPosition = -1;
        } else {
            this.buffer = in.array();
            this.initialBufferPosition = this.bufferPosition = in.arrayOffset() + in.readerIndex();
            this.bufferEnd = this.bufferPosition + in.readableBytes();
            in.readerIndex(in.readerIndex() + in.readableBytes());
        }
    }

    public TNiftyTransport(Channel channel, ThriftMessage message) {
        this(channel, message.getBuffer(), message.getTransportType());
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void open() throws TTransportException {
    }

    public void close() {
        this.channel.close();
    }

    public int read(byte[] bytes, int offset, int length) throws TTransportException {
        if (this.getBytesRemainingInBuffer() >= 0) {
            int _read = Math.min(this.getBytesRemainingInBuffer(), length);
            System.arraycopy(this.getBuffer(), this.getBufferPosition(), bytes, offset, _read);
            this.consumeBuffer(_read);
            return _read;
        }
        int _read = Math.min(this.in.readableBytes(), length);
        this.in.readBytes(bytes, offset, _read);
        return _read;
    }

    public int readAll(byte[] bytes, int offset, int length) throws TTransportException {
        if (this.read(bytes, offset, length) < length) {
            throw new TTransportException("Buffer doesn't have enough bytes to read");
        }
        return length;
    }

    public void write(byte[] bytes, int offset, int length) throws TTransportException {
        this.out.writeBytes(bytes, offset, length);
    }

    public ChannelBuffer getOutputBuffer() {
        return this.out;
    }

    public ThriftTransportType getTransportType() {
        return this.thriftTransportType;
    }

    public void flush() throws TTransportException {
    }

    public void consumeBuffer(int len) {
        this.bufferPosition += len;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getBufferPosition() {
        return this.bufferPosition;
    }

    public int getBytesRemainingInBuffer() {
        return this.bufferEnd - this.bufferPosition;
    }

    public int getReadByteCount() {
        if (this.getBytesRemainingInBuffer() >= 0) {
            return this.getBufferPosition() - this.initialBufferPosition;
        }
        return this.in.readerIndex() - this.initialReaderIndex;
    }

    public int getWrittenByteCount() {
        return this.getOutputBuffer().writerIndex();
    }
}

