/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.core;

import com.facebook.nifty.core.ConnectionContext;
import com.facebook.nifty.core.ConnectionContexts;
import com.facebook.nifty.core.NiftyRequestContext;
import com.facebook.nifty.core.RequestContexts;
import com.facebook.nifty.core.TNiftyTransport;
import com.facebook.nifty.core.ThriftMessage;
import com.facebook.nifty.core.ThriftServerDef;
import com.facebook.nifty.duplex.TDuplexProtocolFactory;
import com.facebook.nifty.duplex.TProtocolPair;
import com.facebook.nifty.duplex.TTransportPair;
import com.facebook.nifty.processor.NiftyProcessorFactory;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;

public class NiftyDispatcher
extends SimpleChannelUpstreamHandler {
    private final NiftyProcessorFactory processorFactory;
    private final Executor exe;
    private final long taskTimeoutMillis;
    private final Timer taskTimeoutTimer;
    private final int queuedResponseLimit;
    private final Map<Integer, ThriftMessage> responseMap = new HashMap<Integer, ThriftMessage>();
    private final AtomicInteger dispatcherSequenceId = new AtomicInteger(0);
    private final AtomicInteger lastResponseWrittenId = new AtomicInteger(0);
    private final TDuplexProtocolFactory duplexProtocolFactory;

    public NiftyDispatcher(ThriftServerDef def, Timer timer) {
        this.processorFactory = def.getProcessorFactory();
        this.duplexProtocolFactory = def.getDuplexProtocolFactory();
        this.queuedResponseLimit = def.getQueuedResponseLimit();
        this.exe = def.getExecutor();
        this.taskTimeoutMillis = def.getTaskTimeout() == null ? 0L : def.getTaskTimeout().toMillis();
        this.taskTimeoutTimer = def.getTaskTimeout() == null ? null : timer;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (e.getMessage() instanceof ThriftMessage) {
            ThriftMessage message = (ThriftMessage)e.getMessage();
            if (this.taskTimeoutMillis > 0L) {
                message.setProcessStartTimeMillis(System.currentTimeMillis());
            }
            this.checkResponseOrderingRequirements(ctx, message);
            TNiftyTransport messageTransport = new TNiftyTransport(ctx.getChannel(), message);
            TTransportPair transportPair = TTransportPair.fromSingleTransport(messageTransport);
            TProtocolPair protocolPair = this.duplexProtocolFactory.getProtocolPair(transportPair);
            TProtocol inProtocol = protocolPair.getInputProtocol();
            TProtocol outProtocol = protocolPair.getOutputProtocol();
            try {
                this.processRequest(ctx, message, messageTransport, inProtocol, outProtocol);
            }
            catch (RejectedExecutionException ex) {
                TApplicationException x = new TApplicationException(6, "Server overloaded");
                this.sendTApplicationException(x, ctx, message, messageTransport, inProtocol, outProtocol);
            }
        } else {
            ctx.sendUpstream((ChannelEvent)e);
        }
    }

    private void checkResponseOrderingRequirements(ChannelHandlerContext ctx, ThriftMessage message) {
        boolean messageRequiresOrderedResponses = message.isOrderedResponsesRequired();
        if (!DispatcherContext.isResponseOrderingRequirementInitialized(ctx)) {
            DispatcherContext.setResponseOrderingRequired(ctx, messageRequiresOrderedResponses);
        } else {
            Preconditions.checkState((messageRequiresOrderedResponses == DispatcherContext.isResponseOrderingRequired(ctx) ? 1 : 0) != 0, (Object)"Every message on a single channel must specify the same requirement for response ordering");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest(final ChannelHandlerContext ctx, final ThriftMessage message, final TNiftyTransport messageTransport, final TProtocol inProtocol, final TProtocol outProtocol) {
        final int requestSequenceId = this.dispatcherSequenceId.incrementAndGet();
        Map<Integer, ThriftMessage> map = this.responseMap;
        synchronized (map) {
            if (requestSequenceId > this.lastResponseWrittenId.get() + this.queuedResponseLimit && !DispatcherContext.isChannelReadBlocked(ctx)) {
                DispatcherContext.blockChannelReads(ctx);
            }
        }
        this.exe.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                final AtomicBoolean responseSent = new AtomicBoolean(false);
                try {
                    ListenableFuture<Boolean> processFuture;
                    try {
                        long timeRemaining = 0L;
                        if (NiftyDispatcher.this.taskTimeoutMillis > 0L) {
                            long timeElapsed = System.currentTimeMillis() - message.getProcessStartTimeMillis();
                            if (timeElapsed >= NiftyDispatcher.this.taskTimeoutMillis) {
                                TApplicationException taskTimeoutException = new TApplicationException(6, "Task stayed on the queue for " + timeElapsed + " milliseconds, exceeding configured task timeout of " + NiftyDispatcher.this.taskTimeoutMillis + " milliseconds.");
                                NiftyDispatcher.this.sendTApplicationException(taskTimeoutException, ctx, message, messageTransport, inProtocol, outProtocol);
                                return;
                            }
                            timeRemaining = NiftyDispatcher.this.taskTimeoutMillis - timeElapsed;
                        }
                        if (timeRemaining > 0L) {
                            NiftyDispatcher.this.taskTimeoutTimer.newTimeout(new TimerTask(){

                                public void run(Timeout timeout) throws Exception {
                                    if (responseSent.compareAndSet(false, true)) {
                                        TApplicationException ex = new TApplicationException(6, "Task timed out while executing.");
                                        ChannelBuffer duplicateBuffer = message.getBuffer().duplicate();
                                        duplicateBuffer.resetReaderIndex();
                                        TNiftyTransport temporaryTransport = new TNiftyTransport(ctx.getChannel(), duplicateBuffer, message.getTransportType());
                                        TProtocolPair protocolPair = NiftyDispatcher.this.duplexProtocolFactory.getProtocolPair(TTransportPair.fromSingleTransport(temporaryTransport));
                                        NiftyDispatcher.this.sendTApplicationException(ex, ctx, message, temporaryTransport, protocolPair.getInputProtocol(), protocolPair.getOutputProtocol());
                                    }
                                }
                            }, timeRemaining, TimeUnit.MILLISECONDS);
                        }
                        ConnectionContext connectionContext = ConnectionContexts.getContext(ctx.getChannel());
                        NiftyRequestContext requestContext = new NiftyRequestContext(connectionContext, inProtocol, outProtocol, messageTransport);
                        RequestContexts.setCurrentContext(requestContext);
                        processFuture = NiftyDispatcher.this.processorFactory.getProcessor(messageTransport).process(inProtocol, outProtocol, requestContext);
                    }
                    finally {
                        RequestContexts.clearCurrentContext();
                    }
                    Futures.addCallback(processFuture, (FutureCallback)new FutureCallback<Boolean>(){

                        public void onSuccess(Boolean result) {
                            try {
                                if (ctx.getChannel().isConnected() && responseSent.compareAndSet(false, true)) {
                                    ThriftMessage response = message.getMessageFactory().create(messageTransport.getOutputBuffer());
                                    NiftyDispatcher.this.writeResponse(ctx, response, requestSequenceId, DispatcherContext.isResponseOrderingRequired(ctx));
                                }
                            }
                            catch (Throwable t) {
                                NiftyDispatcher.this.onDispatchException(ctx, t);
                            }
                        }

                        public void onFailure(Throwable t) {
                            NiftyDispatcher.this.onDispatchException(ctx, t);
                        }
                    });
                }
                catch (TException e) {
                    NiftyDispatcher.this.onDispatchException(ctx, e);
                }
            }
        });
    }

    private void sendTApplicationException(TApplicationException x, ChannelHandlerContext ctx, ThriftMessage request, TNiftyTransport requestTransport, TProtocol inProtocol, TProtocol outProtocol) {
        if (ctx.getChannel().isConnected()) {
            try {
                TMessage message = inProtocol.readMessageBegin();
                outProtocol.writeMessageBegin(new TMessage(message.name, 3, message.seqid));
                x.write(outProtocol);
                outProtocol.writeMessageEnd();
                outProtocol.getTransport().flush();
                ThriftMessage response = request.getMessageFactory().create(requestTransport.getOutputBuffer());
                this.writeResponse(ctx, response, message.seqid, DispatcherContext.isResponseOrderingRequired(ctx));
            }
            catch (TException ex) {
                this.onDispatchException(ctx, ex);
            }
        }
    }

    private void onDispatchException(ChannelHandlerContext ctx, Throwable t) {
        Channels.fireExceptionCaught((ChannelHandlerContext)ctx, (Throwable)t);
        this.closeChannel(ctx);
    }

    private void writeResponse(ChannelHandlerContext ctx, ThriftMessage response, int responseSequenceId, boolean isOrderedResponsesRequired) {
        if (isOrderedResponsesRequired) {
            this.writeResponseInOrder(ctx, response, responseSequenceId);
        } else {
            Channels.write((Channel)ctx.getChannel(), (Object)response);
            this.lastResponseWrittenId.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResponseInOrder(ChannelHandlerContext ctx, ThriftMessage response, int responseSequenceId) {
        Map<Integer, ThriftMessage> map = this.responseMap;
        synchronized (map) {
            int currentResponseId = this.lastResponseWrittenId.get() + 1;
            if (responseSequenceId != currentResponseId) {
                this.responseMap.put(responseSequenceId, response);
            } else {
                int lastRequestSequenceId;
                do {
                    Channels.write((Channel)ctx.getChannel(), (Object)response);
                    this.lastResponseWrittenId.incrementAndGet();
                } while (null != (response = this.responseMap.remove(++currentResponseId)));
                if (DispatcherContext.isChannelReadBlocked(ctx) && (lastRequestSequenceId = this.dispatcherSequenceId.get()) <= this.lastResponseWrittenId.get() + this.queuedResponseLimit) {
                    DispatcherContext.unblockChannelReads(ctx);
                }
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        this.closeChannel(ctx);
        ctx.sendUpstream((ChannelEvent)e);
    }

    private void closeChannel(ChannelHandlerContext ctx) {
        if (ctx.getChannel().isOpen()) {
            ctx.getChannel().close();
        }
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        DispatcherContext.unblockChannelReads(ctx);
        super.channelOpen(ctx, e);
    }

    private static class DispatcherContext {
        private ReadBlockedState readBlockedState = ReadBlockedState.NOT_BLOCKED;
        private boolean responseOrderingRequired = false;
        private boolean responseOrderingRequirementInitialized = false;

        private DispatcherContext() {
        }

        public static boolean isChannelReadBlocked(ChannelHandlerContext ctx) {
            return DispatcherContext.getDispatcherContext((ChannelHandlerContext)ctx).readBlockedState == ReadBlockedState.BLOCKED;
        }

        public static void blockChannelReads(ChannelHandlerContext ctx) {
            DispatcherContext.getDispatcherContext((ChannelHandlerContext)ctx).readBlockedState = ReadBlockedState.BLOCKED;
            ctx.getChannel().setReadable(false);
        }

        public static void unblockChannelReads(ChannelHandlerContext ctx) {
            DispatcherContext.getDispatcherContext((ChannelHandlerContext)ctx).readBlockedState = ReadBlockedState.NOT_BLOCKED;
            ctx.getChannel().setReadable(true);
        }

        public static void setResponseOrderingRequired(ChannelHandlerContext ctx, boolean required) {
            DispatcherContext dispatcherContext = DispatcherContext.getDispatcherContext(ctx);
            dispatcherContext.responseOrderingRequirementInitialized = true;
            dispatcherContext.responseOrderingRequired = required;
        }

        public static boolean isResponseOrderingRequired(ChannelHandlerContext ctx) {
            return DispatcherContext.getDispatcherContext((ChannelHandlerContext)ctx).responseOrderingRequired;
        }

        public static boolean isResponseOrderingRequirementInitialized(ChannelHandlerContext ctx) {
            return DispatcherContext.getDispatcherContext((ChannelHandlerContext)ctx).responseOrderingRequirementInitialized;
        }

        private static DispatcherContext getDispatcherContext(ChannelHandlerContext ctx) {
            DispatcherContext dispatcherContext;
            Object attachment = ctx.getAttachment();
            if (attachment == null) {
                dispatcherContext = new DispatcherContext();
                ctx.setAttachment((Object)dispatcherContext);
            } else {
                if (!(attachment instanceof DispatcherContext)) {
                    throw new IllegalStateException("NiftyDispatcher handler context should be of type NiftyDispatcher.DispatcherContext");
                }
                dispatcherContext = (DispatcherContext)attachment;
            }
            return dispatcherContext;
        }

        private static enum ReadBlockedState {
            NOT_BLOCKED,
            BLOCKED;

        }
    }
}

