/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.core;

import com.facebook.nifty.core.ConnectionContext;
import com.google.common.base.Preconditions;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class NiftyConnectionContext
implements ConnectionContext {
    private SocketAddress remoteAddress;
    private Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();

    @Override
    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(SocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    @Override
    public Object getAttribute(String attributeName) {
        Preconditions.checkNotNull((Object)attributeName);
        return this.attributes.get(attributeName);
    }

    @Override
    public Object setAttribute(String attributeName, Object value) {
        Preconditions.checkNotNull((Object)attributeName);
        Preconditions.checkNotNull((Object)value);
        return this.attributes.put(attributeName, value);
    }

    @Override
    public Object removeAttribute(String attributeName) {
        Preconditions.checkNotNull((Object)attributeName);
        return this.attributes.remove(attributeName);
    }

    @Override
    public Iterator<Map.Entry<String, Object>> attributeIterator() {
        return Collections.unmodifiableSet(this.attributes.entrySet()).iterator();
    }
}

