/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.core;

import com.facebook.nifty.core.NettyConfigBuilderBase;
import com.facebook.nifty.core.NettyServerConfig;
import com.facebook.nifty.core.NiftyTimer;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.netty.channel.socket.ServerSocketChannelConfig;
import org.jboss.netty.channel.socket.nio.NioSocketChannelConfig;
import org.jboss.netty.util.Timer;

public class NettyServerConfigBuilder
extends NettyConfigBuilderBase<NettyServerConfigBuilder> {
    private final NioSocketChannelConfig socketChannelConfig = (NioSocketChannelConfig)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{NioSocketChannelConfig.class}, (InvocationHandler)new NettyConfigBuilderBase.Magic(this, "child."));
    private final ServerSocketChannelConfig serverSocketChannelConfig = (ServerSocketChannelConfig)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ServerSocketChannelConfig.class}, (InvocationHandler)new NettyConfigBuilderBase.Magic(this, ""));

    @Inject
    public NettyServerConfigBuilder() {
        this.getSocketChannelConfig().setTcpNoDelay(true);
    }

    public NioSocketChannelConfig getSocketChannelConfig() {
        return this.socketChannelConfig;
    }

    public ServerSocketChannelConfig getServerSocketChannelConfig() {
        return this.serverSocketChannelConfig;
    }

    public NettyServerConfig build() {
        Timer timer = this.getTimer();
        ExecutorService bossExecutor = this.getBossExecutor();
        int bossThreadCount = this.getBossThreadCount();
        ExecutorService workerExecutor = this.getWorkerExecutor();
        int workerThreadCount = this.getWorkerThreadCount();
        return new NettyServerConfig(this.getBootstrapOptions(), (Timer)(timer != null ? timer : new NiftyTimer(this.threadNamePattern(""))), bossExecutor != null ? bossExecutor : this.buildDefaultBossExecutor(), bossThreadCount, workerExecutor != null ? workerExecutor : this.buildDefaultWorkerExecutor(), workerThreadCount);
    }

    private ExecutorService buildDefaultBossExecutor() {
        return Executors.newCachedThreadPool(this.renamingThreadFactory(this.threadNamePattern("-boss-%s")));
    }

    private ExecutorService buildDefaultWorkerExecutor() {
        return Executors.newCachedThreadPool(this.renamingThreadFactory(this.threadNamePattern("-worker-%s")));
    }

    private String threadNamePattern(String suffix) {
        String niftyName = this.getNiftyName();
        return "nifty-server" + (Strings.isNullOrEmpty((String)niftyName) ? "" : "-" + niftyName) + suffix;
    }

    private ThreadFactory renamingThreadFactory(String nameFormat) {
        return new ThreadFactoryBuilder().setNameFormat(nameFormat).build();
    }
}

