/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.gora.utils;

import org.apache.gora.persistency.Persistent;
import org.apache.gora.query.Query;
import org.apache.gora.query.Result;
import org.apache.gora.query.impl.QueryBase;
import org.apache.gora.store.DataStore;
import org.apache.gora.store.DataStoreFactory;
import org.apache.gora.util.GoraException;
import org.apache.hadoop.conf.Configuration;

public class GoraUtils {
    private static Class<? extends DataStore> DATASTORECLASS;

    private GoraUtils() {
    }

    public static <K, T extends Persistent> DataStore<K, T> createDataStore(Configuration conf, Class<K> keyClass, Class<T> persistentClass) throws GoraException {
        DataStoreFactory.createProps();
        DataStore dataStore = DataStoreFactory.createDataStore(DATASTORECLASS, keyClass, persistentClass, (Configuration)conf);
        return dataStore;
    }

    public static <K, T extends Persistent> DataStore<K, T> createSpecificDataStore(Configuration conf, Class<? extends DataStore> dataStoreClass, Class<K> keyClass, Class<T> persistentClass) throws GoraException {
        DATASTORECLASS = dataStoreClass;
        return GoraUtils.createDataStore(conf, keyClass, persistentClass);
    }

    public static <K, T extends Persistent> Result<K, T> getRequest(DataStore<K, T> pDataStore, K pStartKey, K pEndKey) {
        QueryBase query = GoraUtils.getQuery(pDataStore, pStartKey, pEndKey);
        return GoraUtils.getRequest(pDataStore, query);
    }

    public static <K, T extends Persistent> Result<K, T> getRequest(DataStore<K, T> pDataStore, Query<K, T> query) {
        return pDataStore.execute(query);
    }

    public static <K, T extends Persistent> Result<K, T> getRequest(DataStore<K, T> pDataStore, K pStartKey) {
        return GoraUtils.getRequest(pDataStore, pStartKey, null);
    }

    public static <K, T extends Persistent> QueryBase getQuery(DataStore pDataStore, K pStartKey, K pEndKey) {
        QueryBase query = (QueryBase)pDataStore.newQuery();
        query.setStartKey(pStartKey);
        query.setEndKey(pEndKey);
        return query;
    }

    public static <K, T extends Persistent> Query<K, T> getQuery(DataStore<K, T> pDataStore, K pStartKey) {
        Query query = pDataStore.newQuery();
        query.setStartKey(pStartKey);
        query.setEndKey(null);
        return query;
    }

    public static <K, T extends Persistent> Query<K, T> getQuery(DataStore<K, T> pDataStore) {
        Query query = pDataStore.newQuery();
        query.setStartKey(null);
        query.setEndKey(null);
        return query;
    }
}

