/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.gora.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.gora.mapreduce.GoraInputSplit;
import org.apache.gora.mapreduce.GoraMapReduceUtils;
import org.apache.gora.mapreduce.GoraRecordReader;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.query.PartitionQuery;
import org.apache.gora.query.Query;
import org.apache.gora.query.impl.PartitionQueryImpl;
import org.apache.gora.store.DataStore;
import org.apache.gora.util.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class ExtraGoraInputFormat<K, T extends PersistentBase>
extends InputFormat<K, T> {
    public static final String QUERY_KEY = "gora.inputformat.query";
    private DataStore<K, T> dataStore;
    private Query<K, T> query;

    public RecordReader<K, T> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        PartitionQuery partitionQuery = ((GoraInputSplit)split).getQuery();
        return new GoraRecordReader((Query)partitionQuery, context);
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        List queries = this.getDataStore().getPartitions(this.getQuery());
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>(queries.size());
        for (PartitionQuery partQuery : queries) {
            ((PartitionQueryImpl)partQuery).setConf(context.getConfiguration());
            splits.add((InputSplit)new GoraInputSplit(context.getConfiguration(), partQuery));
        }
        return splits;
    }

    public DataStore<K, T> getDataStore() {
        return this.dataStore;
    }

    public void setDataStore(DataStore<K, T> datStore) {
        this.dataStore = datStore;
    }

    public Query<K, T> getQuery() {
        return this.query;
    }

    public void setQuery(Query<K, T> query) {
        this.query = query;
    }

    public static <K, T extends Persistent> void setQuery(Configuration conf, Query<K, T> query) throws IOException {
        IOUtils.storeToConf(query, (Configuration)conf, (String)QUERY_KEY);
    }

    public Query<K, T> getQuery(Configuration conf) throws IOException {
        return (Query)IOUtils.loadFromConf((Configuration)conf, (String)QUERY_KEY);
    }

    public static <K, V extends Persistent> void setInput(Job job, Query<K, V> query, DataStore<K, V> dataStore, boolean reuseObjects) throws IOException {
        Configuration conf = job.getConfiguration();
        GoraMapReduceUtils.setIOSerializations((Configuration)conf, (boolean)reuseObjects);
        job.setInputFormatClass(ExtraGoraInputFormat.class);
        ExtraGoraInputFormat.setQuery(job.getConfiguration(), query);
    }
}

