/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.gora;

import java.io.IOException;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.VertexOutputFormat;
import org.apache.giraph.io.VertexWriter;
import org.apache.giraph.io.gora.constants.GiraphGoraConstants;
import org.apache.giraph.io.gora.utils.GoraUtils;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.store.DataStore;
import org.apache.gora.util.GoraException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Logger;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

public abstract class GoraVertexOutputFormat<I extends WritableComparable, V extends Writable, E extends Writable>
extends VertexOutputFormat<I, V, E> {
    private static final Logger LOG = Logger.getLogger(GoraVertexOutputFormat.class);
    private static Class<?> KEY_CLASS;
    private static Class<? extends Persistent> PERSISTENT_CLASS;
    private static Class<? extends DataStore> DATASTORE_CLASS;
    private static DataStore DATA_STORE;

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
    }

    public DataStore createDataStore(Configuration conf) {
        DataStore<?, Persistent> dsCreated = null;
        try {
            dsCreated = GoraUtils.createSpecificDataStore(conf, GoraVertexOutputFormat.getDatastoreClass(), GoraVertexOutputFormat.getKeyClass(), GoraVertexOutputFormat.getPersistentClass());
        }
        catch (GoraException e) {
            GoraVertexOutputFormat.getLogger().error((Object)"Error creating data store.");
            e.printStackTrace();
        }
        return dsCreated;
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new NullOutputCommitter();
    }

    public static DataStore getDataStore() {
        return DATA_STORE;
    }

    public static void setDataStore(DataStore dStore) {
        DATA_STORE = dStore;
    }

    static Class<? extends Persistent> getPersistentClass() {
        return PERSISTENT_CLASS;
    }

    static void setPersistentClass(Class<? extends Persistent> persistentClassUsed) {
        PERSISTENT_CLASS = persistentClassUsed;
    }

    static Class<?> getKeyClass() {
        return KEY_CLASS;
    }

    static void setKeyClass(Class<?> keyClassUsed) {
        KEY_CLASS = keyClassUsed;
    }

    public static Class<? extends DataStore> getDatastoreClass() {
        return DATASTORE_CLASS;
    }

    public static void setDatastoreClass(Class<? extends DataStore> dataStoreClass) {
        DATASTORE_CLASS = dataStoreClass;
    }

    public static Logger getLogger() {
        return LOG;
    }

    protected abstract class GoraVertexWriter
    extends VertexWriter<I, V, E>
    implements Watcher {
        private final Object lock = new Object();

        protected GoraVertexWriter() {
        }

        public void initialize(TaskAttemptContext context) throws IOException, InterruptedException {
            String sDataStoreType = GiraphGoraConstants.GIRAPH_GORA_OUTPUT_DATASTORE_CLASS.get((Configuration)this.getConf());
            String sKeyType = GiraphGoraConstants.GIRAPH_GORA_OUTPUT_KEY_CLASS.get((Configuration)this.getConf());
            String sPersistentType = GiraphGoraConstants.GIRAPH_GORA_OUTPUT_PERSISTENT_CLASS.get((Configuration)this.getConf());
            try {
                Class<?> keyClass = Class.forName(sKeyType);
                Class<?> persistentClass = Class.forName(sPersistentType);
                Class<?> dataStoreClass = Class.forName(sDataStoreType);
                GoraVertexOutputFormat.setKeyClass(keyClass);
                GoraVertexOutputFormat.setPersistentClass(persistentClass);
                GoraVertexOutputFormat.setDatastoreClass(dataStoreClass);
                GoraVertexOutputFormat.setDataStore(GoraVertexOutputFormat.this.createDataStore(context.getConfiguration()));
                if (GoraVertexOutputFormat.getDataStore() != null) {
                    GoraVertexOutputFormat.getLogger().info((Object)"The output data store has been created.");
                }
            }
            catch (ClassNotFoundException e) {
                GoraVertexOutputFormat.getLogger().error((Object)"Error while reading Gora Output parameters");
                e.printStackTrace();
            }
        }

        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            GoraVertexOutputFormat.getDataStore().flush();
            GoraVertexOutputFormat.getDataStore().close();
        }

        public void writeVertex(Vertex<I, V, E> vertex) throws IOException, InterruptedException {
            Persistent goraVertex = null;
            Object goraKey = this.getGoraKey(vertex);
            goraVertex = this.getGoraVertex(vertex);
            GoraVertexOutputFormat.getDataStore().put(goraKey, goraVertex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent event) {
            Watcher.Event.EventType type = event.getType();
            if (type == Watcher.Event.EventType.NodeChildrenChanged) {
                if (GoraVertexOutputFormat.getLogger().isDebugEnabled()) {
                    GoraVertexOutputFormat.getLogger().debug((Object)"signal: number of children changed.");
                }
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notify();
                }
            }
        }

        protected abstract Persistent getGoraVertex(Vertex<I, V, E> var1);

        protected abstract Object getGoraKey(Vertex<I, V, E> var1);
    }

    private static class NullOutputCommitter
    extends OutputCommitter {
        private NullOutputCommitter() {
        }

        public void abortTask(TaskAttemptContext arg0) throws IOException {
        }

        public void commitTask(TaskAttemptContext arg0) throws IOException {
        }

        public boolean needsTaskCommit(TaskAttemptContext arg0) throws IOException {
            return false;
        }

        public void setupJob(JobContext arg0) throws IOException {
        }

        public void setupTask(TaskAttemptContext arg0) throws IOException {
        }
    }
}

