/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.gora;

import java.io.IOException;
import java.util.List;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.VertexInputFormat;
import org.apache.giraph.io.VertexReader;
import org.apache.giraph.io.gora.constants.GiraphGoraConstants;
import org.apache.giraph.io.gora.utils.ExtraGoraInputFormat;
import org.apache.giraph.io.gora.utils.GoraUtils;
import org.apache.giraph.io.gora.utils.KeyFactory;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.query.Result;
import org.apache.gora.query.impl.QueryBase;
import org.apache.gora.store.DataStore;
import org.apache.gora.util.GoraException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Logger;

public abstract class GoraVertexInputFormat<I extends WritableComparable, V extends Writable, E extends Writable>
extends VertexInputFormat<I, V, E> {
    private static Object START_KEY;
    private static Object END_KEY;
    private static final Logger LOG;
    private static Class<?> KEY_CLASS;
    private static Class<? extends Persistent> PERSISTENT_CLASS;
    private static Class<? extends DataStore> DATASTORE_CLASS;
    private static Class<?> KEY_FACTORY_CLASS;
    private static DataStore DATA_STORE;
    private static int RECORD_COUNTER;
    private static ExtraGoraInputFormat GORA_INPUT_FORMAT;

    public void checkInputSpecs(Configuration conf) {
        String sDataStoreType = GiraphGoraConstants.GIRAPH_GORA_DATASTORE_CLASS.get((Configuration)this.getConf());
        String sKeyType = GiraphGoraConstants.GIRAPH_GORA_KEY_CLASS.get((Configuration)this.getConf());
        String sPersistentType = GiraphGoraConstants.GIRAPH_GORA_PERSISTENT_CLASS.get((Configuration)this.getConf());
        String sKeyFactoryClass = GiraphGoraConstants.GIRAPH_GORA_KEYS_FACTORY_CLASS.get((Configuration)this.getConf());
        try {
            Class<?> keyClass = Class.forName(sKeyType);
            Class<?> persistentClass = Class.forName(sPersistentType);
            Class<?> dataStoreClass = Class.forName(sDataStoreType);
            Class<?> keyFactoryClass = Class.forName(sKeyFactoryClass);
            GoraVertexInputFormat.setKeyClass(keyClass);
            GoraVertexInputFormat.setPersistentClass(persistentClass);
            GoraVertexInputFormat.setDatastoreClass(dataStoreClass);
            GoraVertexInputFormat.setKeyFactoryClass(keyFactoryClass);
            GoraVertexInputFormat.setDataStore(this.createDataStore(conf));
            GORA_INPUT_FORMAT.setDataStore(GoraVertexInputFormat.getDataStore());
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)"Error while reading Gora Input parameters");
            e.printStackTrace();
        }
    }

    public abstract GoraVertexReader createVertexReader(InputSplit var1, TaskAttemptContext var2) throws IOException;

    public List<InputSplit> getSplits(JobContext context, int minSplitCountHint) throws IOException, InterruptedException {
        KeyFactory kFact = null;
        try {
            kFact = (KeyFactory)GoraVertexInputFormat.getKeyFactoryClass().newInstance();
            kFact.setDataStore(GoraVertexInputFormat.getDataStore());
        }
        catch (InstantiationException e) {
            LOG.error((Object)"Key factory was not instantiated. Please verify.");
            LOG.error((Object)e.getMessage());
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)"Key factory was not instantiated. Please verify.");
            LOG.error((Object)e.getMessage());
            e.printStackTrace();
        }
        String sKey = GiraphGoraConstants.GIRAPH_GORA_START_KEY.get((Configuration)this.getConf());
        String eKey = GiraphGoraConstants.GIRAPH_GORA_END_KEY.get((Configuration)this.getConf());
        if (sKey == null || sKey.isEmpty()) {
            LOG.warn((Object)"No start key has been defined.");
            LOG.warn((Object)"Querying all the data store.");
            sKey = null;
            eKey = null;
        } else {
            GoraVertexInputFormat.setStartKey(kFact.buildKey(sKey));
            GoraVertexInputFormat.setEndKey(kFact.buildKey(eKey));
        }
        QueryBase tmpQuery = GoraUtils.getQuery(GoraVertexInputFormat.getDataStore(), this.getStartKey(), GoraVertexInputFormat.getEndKey());
        tmpQuery.setConf((Configuration)this.getConf());
        GORA_INPUT_FORMAT.setQuery(tmpQuery);
        List<InputSplit> splits = GORA_INPUT_FORMAT.getSplits(context);
        return splits;
    }

    public DataStore createDataStore(Configuration conf) {
        DataStore<?, Persistent> dsCreated = null;
        try {
            dsCreated = GoraUtils.createSpecificDataStore(conf, GoraVertexInputFormat.getDatastoreClass(), GoraVertexInputFormat.getKeyClass(), GoraVertexInputFormat.getPersistentClass());
        }
        catch (GoraException e) {
            LOG.error((Object)"Error creating data store.");
            e.printStackTrace();
        }
        return dsCreated;
    }

    static Class<? extends Persistent> getPersistentClass() {
        return PERSISTENT_CLASS;
    }

    static void setPersistentClass(Class<? extends Persistent> persistentClassUsed) {
        PERSISTENT_CLASS = persistentClassUsed;
    }

    static Class<?> getKeyClass() {
        return KEY_CLASS;
    }

    static void setKeyClass(Class<?> keyClassUsed) {
        KEY_CLASS = keyClassUsed;
    }

    public static Class<? extends DataStore> getDatastoreClass() {
        return DATASTORE_CLASS;
    }

    public static void setDatastoreClass(Class<? extends DataStore> dataStoreClass) {
        DATASTORE_CLASS = dataStoreClass;
    }

    public Object getStartKey() {
        return START_KEY;
    }

    public static void setStartKey(Object startKey) {
        START_KEY = startKey;
    }

    static Object getEndKey() {
        return END_KEY;
    }

    static void setEndKey(Object pEndKey) {
        END_KEY = pEndKey;
    }

    static Class<?> getKeyFactoryClass() {
        return KEY_FACTORY_CLASS;
    }

    static void setKeyFactoryClass(Class<?> keyFactoryClass) {
        KEY_FACTORY_CLASS = keyFactoryClass;
    }

    public static DataStore getDataStore() {
        return DATA_STORE;
    }

    public static void setDataStore(DataStore dStore) {
        DATA_STORE = dStore;
    }

    static {
        LOG = Logger.getLogger(GoraVertexInputFormat.class);
        RECORD_COUNTER = 0;
        GORA_INPUT_FORMAT = new ExtraGoraInputFormat();
    }

    protected abstract class GoraVertexReader
    extends VertexReader<I, V, E> {
        private Vertex<I, V, E> vertex;
        private Result readResults;

        protected GoraVertexReader() {
        }

        public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
            this.getResults();
            RECORD_COUNTER = 0;
        }

        public boolean nextVertex() throws IOException, InterruptedException {
            boolean flg = false;
            try {
                flg = this.getReadResults().next();
                this.vertex = this.transformVertex(this.getReadResults().get());
                RECORD_COUNTER++;
            }
            catch (Exception e) {
                LOG.error((Object)"Error transforming vertices.");
                LOG.error((Object)e.getMessage());
                flg = false;
            }
            LOG.debug((Object)(RECORD_COUNTER + " were transformed."));
            return flg;
        }

        public float getProgress() throws IOException, InterruptedException {
            float progress = 0.0f;
            if (this.getReadResults() != null) {
                progress = this.getReadResults().getProgress();
            }
            return progress;
        }

        public Vertex<I, V, E> getCurrentVertex() throws IOException, InterruptedException {
            return this.vertex;
        }

        protected abstract Vertex<I, V, E> transformVertex(Object var1);

        protected void getResults() {
            this.setReadResults(GoraUtils.getRequest(GoraVertexInputFormat.getDataStore(), GoraVertexInputFormat.this.getStartKey(), GoraVertexInputFormat.getEndKey()));
        }

        public void close() throws IOException {
        }

        Result getReadResults() {
            return this.readResults;
        }

        void setReadResults(Result readResults) {
            this.readResults = readResults;
        }
    }
}

