/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.gora;

import java.io.IOException;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.VertexWriter;
import org.apache.giraph.io.gora.GoraVertexOutputFormat;
import org.apache.giraph.io.gora.generated.GVertexResult;
import org.apache.gora.persistency.Persistent;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class GoraGVertexVertexOutputFormat
extends GoraVertexOutputFormat<LongWritable, DoubleWritable, FloatWritable> {
    public VertexWriter<LongWritable, DoubleWritable, FloatWritable> createVertexWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new GoraGVertexVertexWriter();
    }

    protected class GoraGVertexVertexWriter
    extends GoraVertexOutputFormat.GoraVertexWriter {
        protected GoraGVertexVertexWriter() {
            super(GoraGVertexVertexOutputFormat.this);
        }

        protected Persistent getGoraVertex(Vertex<LongWritable, DoubleWritable, FloatWritable> vertex) {
            GVertexResult tmpGVertex = new GVertexResult();
            tmpGVertex.setVertexId(((LongWritable)vertex.getId()).toString());
            tmpGVertex.setVertexValue(Float.valueOf(Float.parseFloat(((DoubleWritable)vertex.getValue()).toString())));
            for (Edge edge : vertex.getEdges()) {
                tmpGVertex.getEdges().put(((LongWritable)edge.getTargetVertexId()).toString(), ((FloatWritable)edge.getValue()).toString());
            }
            return tmpGVertex;
        }

        protected Object getGoraKey(Vertex<LongWritable, DoubleWritable, FloatWritable> vertex) {
            String goraKey = String.valueOf(vertex.getId());
            return goraKey;
        }
    }
}

