/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.gora;

import java.io.IOException;
import java.util.Set;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.gora.GoraVertexInputFormat;
import org.apache.giraph.io.gora.generated.GVertex;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class GoraGVertexVertexInputFormat
extends GoraVertexInputFormat<LongWritable, DoubleWritable, FloatWritable> {
    @Override
    public GoraVertexInputFormat.GoraVertexReader createVertexReader(InputSplit split, TaskAttemptContext context) throws IOException {
        return new GoraGVertexVertexReader();
    }

    protected class GoraGVertexVertexReader
    extends GoraVertexInputFormat.GoraVertexReader {
        protected GoraGVertexVertexReader() {
            super(GoraGVertexVertexInputFormat.this);
        }

        protected Vertex<LongWritable, DoubleWritable, FloatWritable> transformVertex(Object goraObject) {
            Vertex vertex = this.getConf().createVertex();
            GVertex tmpGVertex = (GVertex)((Object)goraObject);
            LongWritable vrtxId = new LongWritable(Long.parseLong(tmpGVertex.getVertexId().toString()));
            DoubleWritable vrtxValue = new DoubleWritable((double)tmpGVertex.getVertexValue().floatValue());
            vertex.initialize((WritableComparable)vrtxId, (Writable)vrtxValue);
            if (tmpGVertex.getEdges() != null && !tmpGVertex.getEdges().isEmpty()) {
                Set<CharSequence> keyIt = tmpGVertex.getEdges().keySet();
                for (CharSequence key : keyIt) {
                    String keyVal = key.toString();
                    String valVal = tmpGVertex.getEdges().get(key).toString();
                    if (keyVal.contains("vertexId") || keyVal.contains("value")) continue;
                    Edge edge = EdgeFactory.create((WritableComparable)new LongWritable(Long.parseLong(keyVal)), (Writable)new FloatWritable(Float.parseFloat(valVal)));
                    vertex.addEdge(edge);
                }
            }
            return vertex;
        }
    }
}

