/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.gora;

import java.io.IOException;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.io.gora.GoraEdgeOutputFormat;
import org.apache.giraph.io.gora.generated.GEdgeResult;
import org.apache.gora.persistency.Persistent;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class GoraGEdgeEdgeOutputFormat
extends GoraEdgeOutputFormat<LongWritable, DoubleWritable, FloatWritable> {
    @Override
    public GoraEdgeOutputFormat.GoraEdgeWriter createEdgeWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new GoraGEdgeEdgeWriter();
    }

    protected class GoraGEdgeEdgeWriter
    extends GoraEdgeOutputFormat.GoraEdgeWriter {
        protected GoraGEdgeEdgeWriter() {
        }

        protected Persistent getGoraEdge(LongWritable srcId, DoubleWritable srcValue, Edge<LongWritable, FloatWritable> edge) {
            GEdgeResult tmpGEdge = new GEdgeResult();
            tmpGEdge.setEdgeId(srcId.toString());
            tmpGEdge.setEdgeWeight(Float.valueOf(((FloatWritable)edge.getValue()).get()));
            tmpGEdge.setVertexOutId(((LongWritable)edge.getTargetVertexId()).toString());
            GoraEdgeOutputFormat.getLogger().debug((Object)("GoraObject created: " + tmpGEdge.toString()));
            return tmpGEdge;
        }

        protected Object getGoraKey(LongWritable srcId, DoubleWritable srcValue, Edge<LongWritable, FloatWritable> edge) {
            String goraKey = String.valueOf((float)((LongWritable)edge.getTargetVertexId()).get() + ((FloatWritable)edge.getValue()).get());
            return goraKey;
        }
    }
}

