/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.gora;

import java.io.IOException;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.io.EdgeOutputFormat;
import org.apache.giraph.io.EdgeWriter;
import org.apache.giraph.io.gora.constants.GiraphGoraConstants;
import org.apache.giraph.io.gora.utils.GoraUtils;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.store.DataStore;
import org.apache.gora.util.GoraException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Logger;

public abstract class GoraEdgeOutputFormat<I extends WritableComparable, V extends Writable, E extends Writable>
extends EdgeOutputFormat<I, V, E> {
    private static final Logger LOG = Logger.getLogger(GoraEdgeOutputFormat.class);
    private static Class<?> KEY_CLASS;
    private static Class<? extends Persistent> PERSISTENT_CLASS;
    private static Class<? extends DataStore> DATASTORE_CLASS;
    private static DataStore DATA_STORE;

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
    }

    public DataStore createDataStore(Configuration conf) {
        DataStore<?, Persistent> dsCreated = null;
        try {
            dsCreated = GoraUtils.createSpecificDataStore(conf, GoraEdgeOutputFormat.getDatastoreClass(), GoraEdgeOutputFormat.getKeyClass(), GoraEdgeOutputFormat.getPersistentClass());
        }
        catch (GoraException e) {
            GoraEdgeOutputFormat.getLogger().error((Object)"Error creating data store.");
            e.printStackTrace();
        }
        return dsCreated;
    }

    public abstract GoraEdgeWriter createEdgeWriter(TaskAttemptContext var1) throws IOException, InterruptedException;

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new NullOutputCommitter();
    }

    public static DataStore getDataStore() {
        return DATA_STORE;
    }

    public static void setDataStore(DataStore dStore) {
        DATA_STORE = dStore;
    }

    static Class<? extends Persistent> getPersistentClass() {
        return PERSISTENT_CLASS;
    }

    static void setPersistentClass(Class<? extends Persistent> persistentClassUsed) {
        PERSISTENT_CLASS = persistentClassUsed;
    }

    static Class<?> getKeyClass() {
        return KEY_CLASS;
    }

    static void setKeyClass(Class<?> keyClassUsed) {
        KEY_CLASS = keyClassUsed;
    }

    public static Class<? extends DataStore> getDatastoreClass() {
        return DATASTORE_CLASS;
    }

    public static void setDatastoreClass(Class<? extends DataStore> dataStoreClass) {
        DATASTORE_CLASS = dataStoreClass;
    }

    public static Logger getLogger() {
        return LOG;
    }

    protected abstract class GoraEdgeWriter
    extends EdgeWriter<I, V, E> {
        protected GoraEdgeWriter() {
        }

        public void initialize(TaskAttemptContext context) throws IOException, InterruptedException {
            String sDataStoreType = GiraphGoraConstants.GIRAPH_GORA_OUTPUT_DATASTORE_CLASS.get((Configuration)this.getConf());
            String sKeyType = GiraphGoraConstants.GIRAPH_GORA_OUTPUT_KEY_CLASS.get((Configuration)this.getConf());
            String sPersistentType = GiraphGoraConstants.GIRAPH_GORA_OUTPUT_PERSISTENT_CLASS.get((Configuration)this.getConf());
            try {
                Class<?> keyClass = Class.forName(sKeyType);
                Class<?> persistentClass = Class.forName(sPersistentType);
                Class<?> dataStoreClass = Class.forName(sDataStoreType);
                GoraEdgeOutputFormat.setKeyClass(keyClass);
                GoraEdgeOutputFormat.setPersistentClass(persistentClass);
                GoraEdgeOutputFormat.setDatastoreClass(dataStoreClass);
                GoraEdgeOutputFormat.setDataStore(GoraEdgeOutputFormat.this.createDataStore(context.getConfiguration()));
                if (GoraEdgeOutputFormat.getDataStore() != null) {
                    GoraEdgeOutputFormat.getLogger().debug((Object)"The data store has been created.");
                }
            }
            catch (ClassNotFoundException e) {
                GoraEdgeOutputFormat.getLogger().error((Object)"Error while reading Gora Output parameters");
                e.printStackTrace();
            }
        }

        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            GoraEdgeOutputFormat.getDataStore().flush();
            GoraEdgeOutputFormat.getDataStore().close();
        }

        public void writeEdge(I srcId, V srcValue, Edge<I, E> edge) throws IOException, InterruptedException {
            Persistent goraEdge = null;
            Object goraKey = this.getGoraKey(srcId, srcValue, edge);
            goraEdge = this.getGoraEdge(srcId, srcValue, edge);
            GoraEdgeOutputFormat.getDataStore().put(goraKey, goraEdge);
        }

        protected abstract Persistent getGoraEdge(I var1, V var2, Edge<I, E> var3);

        protected abstract Object getGoraKey(I var1, V var2, Edge<I, E> var3);
    }

    private static class NullOutputCommitter
    extends OutputCommitter {
        private NullOutputCommitter() {
        }

        public void abortTask(TaskAttemptContext arg0) throws IOException {
        }

        public void commitTask(TaskAttemptContext arg0) throws IOException {
        }

        public boolean needsTaskCommit(TaskAttemptContext arg0) throws IOException {
            return false;
        }

        public void setupJob(JobContext arg0) throws IOException {
        }

        public void setupTask(TaskAttemptContext arg0) throws IOException {
        }
    }
}

