/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.gora;

import java.io.IOException;
import java.util.List;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.io.EdgeInputFormat;
import org.apache.giraph.io.EdgeReader;
import org.apache.giraph.io.gora.constants.GiraphGoraConstants;
import org.apache.giraph.io.gora.utils.ExtraGoraInputFormat;
import org.apache.giraph.io.gora.utils.GoraUtils;
import org.apache.giraph.io.gora.utils.KeyFactory;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.query.Result;
import org.apache.gora.query.impl.QueryBase;
import org.apache.gora.store.DataStore;
import org.apache.gora.util.GoraException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Logger;

public abstract class GoraEdgeInputFormat<I extends WritableComparable, E extends Writable>
extends EdgeInputFormat<I, E> {
    private static Object START_KEY;
    private static Object END_KEY;
    private static final Logger LOG;
    private static Class<?> KEY_CLASS;
    private static Class<? extends Persistent> PERSISTENT_CLASS;
    private static Class<? extends DataStore> DATASTORE_CLASS;
    private static Class<?> KEY_FACTORY_CLASS;
    private static DataStore DATA_STORE;
    private static int RECORD_COUNTER;
    private static ExtraGoraInputFormat GORA_INPUT_FORMAT;

    public void checkInputSpecs(Configuration conf) {
        String sDataStoreType = GiraphGoraConstants.GIRAPH_GORA_DATASTORE_CLASS.get((Configuration)this.getConf());
        String sKeyType = GiraphGoraConstants.GIRAPH_GORA_KEY_CLASS.get((Configuration)this.getConf());
        String sPersistentType = GiraphGoraConstants.GIRAPH_GORA_PERSISTENT_CLASS.get((Configuration)this.getConf());
        String sKeyFactoryClass = GiraphGoraConstants.GIRAPH_GORA_KEYS_FACTORY_CLASS.get((Configuration)this.getConf());
        try {
            Class<?> keyClass = Class.forName(sKeyType);
            Class<?> persistentClass = Class.forName(sPersistentType);
            Class<?> dataStoreClass = Class.forName(sDataStoreType);
            Class<?> keyFactoryClass = Class.forName(sKeyFactoryClass);
            GoraEdgeInputFormat.setKeyClass(keyClass);
            GoraEdgeInputFormat.setPersistentClass(persistentClass);
            GoraEdgeInputFormat.setDatastoreClass(dataStoreClass);
            GoraEdgeInputFormat.setKeyFactoryClass(keyFactoryClass);
            GoraEdgeInputFormat.setDataStore(this.createDataStore((Configuration)this.getConf()));
            GORA_INPUT_FORMAT.setDataStore(GoraEdgeInputFormat.getDataStore());
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)"Error while reading Gora Input parameters");
            e.printStackTrace();
        }
    }

    public List<InputSplit> getSplits(JobContext context, int minSplitCountHint) throws IOException, InterruptedException {
        KeyFactory kFact = null;
        try {
            kFact = (KeyFactory)GoraEdgeInputFormat.getKeyFactoryClass().newInstance();
        }
        catch (InstantiationException e) {
            LOG.error((Object)"Key factory was not instantiated. Please verify.");
            LOG.error((Object)e.getMessage());
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)"Key factory was not instantiated. Please verify.");
            LOG.error((Object)e.getMessage());
            e.printStackTrace();
        }
        String sKey = GiraphGoraConstants.GIRAPH_GORA_START_KEY.get((Configuration)this.getConf());
        String eKey = GiraphGoraConstants.GIRAPH_GORA_END_KEY.get((Configuration)this.getConf());
        if (sKey == null || sKey.isEmpty()) {
            LOG.warn((Object)"No start key has been defined.");
            LOG.warn((Object)"Querying all the data store.");
            sKey = null;
            eKey = null;
        }
        kFact.setDataStore(GoraEdgeInputFormat.getDataStore());
        GoraEdgeInputFormat.setStartKey(kFact.buildKey(sKey));
        GoraEdgeInputFormat.setEndKey(kFact.buildKey(eKey));
        QueryBase tmpQuery = GoraUtils.getQuery(GoraEdgeInputFormat.getDataStore(), this.getStartKey(), GoraEdgeInputFormat.getEndKey());
        tmpQuery.setConf(context.getConfiguration());
        GORA_INPUT_FORMAT.setQuery(tmpQuery);
        List<InputSplit> splits = GORA_INPUT_FORMAT.getSplits(context);
        return splits;
    }

    public abstract GoraEdgeReader createEdgeReader(InputSplit var1, TaskAttemptContext var2) throws IOException;

    public DataStore createDataStore(Configuration conf) {
        DataStore<?, Persistent> dsCreated = null;
        try {
            dsCreated = GoraUtils.createSpecificDataStore(conf, GoraEdgeInputFormat.getDatastoreClass(), GoraEdgeInputFormat.getKeyClass(), GoraEdgeInputFormat.getPersistentClass());
        }
        catch (GoraException e) {
            LOG.error((Object)"Error creating data store.");
            e.printStackTrace();
        }
        return dsCreated;
    }

    static Class<? extends Persistent> getPersistentClass() {
        return PERSISTENT_CLASS;
    }

    static void setPersistentClass(Class<? extends Persistent> persistentClassUsed) {
        PERSISTENT_CLASS = persistentClassUsed;
    }

    static Class<?> getKeyClass() {
        return KEY_CLASS;
    }

    static void setKeyClass(Class<?> keyClassUsed) {
        KEY_CLASS = keyClassUsed;
    }

    public static Class<? extends DataStore> getDatastoreClass() {
        return DATASTORE_CLASS;
    }

    public static void setDatastoreClass(Class<? extends DataStore> dataStoreClass) {
        DATASTORE_CLASS = dataStoreClass;
    }

    public Object getStartKey() {
        return START_KEY;
    }

    public static void setStartKey(Object startKey) {
        START_KEY = startKey;
    }

    static Object getEndKey() {
        return END_KEY;
    }

    static void setEndKey(Object pEndKey) {
        END_KEY = pEndKey;
    }

    static Class<?> getKeyFactoryClass() {
        return KEY_FACTORY_CLASS;
    }

    static void setKeyFactoryClass(Class<?> keyFactoryClass) {
        KEY_FACTORY_CLASS = keyFactoryClass;
    }

    public static DataStore getDataStore() {
        return DATA_STORE;
    }

    public static void setDataStore(DataStore dStore) {
        DATA_STORE = dStore;
    }

    public static Logger getLogger() {
        return LOG;
    }

    static {
        LOG = Logger.getLogger(GoraEdgeInputFormat.class);
        RECORD_COUNTER = 0;
        GORA_INPUT_FORMAT = new ExtraGoraInputFormat();
    }

    protected abstract class GoraEdgeReader
    extends EdgeReader<I, E> {
        private Edge<I, E> edge;
        private Result readResults;

        protected GoraEdgeReader() {
        }

        public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
            this.getResults();
            RECORD_COUNTER = 0;
        }

        public boolean nextEdge() throws IOException, InterruptedException {
            boolean flg = false;
            try {
                flg = this.getReadResults().next();
                this.edge = this.transformEdge(this.getReadResults().get());
                RECORD_COUNTER++;
            }
            catch (Exception e) {
                LOG.debug((Object)"Error transforming vertices.");
                flg = false;
            }
            LOG.debug((Object)(RECORD_COUNTER + " were transformed."));
            return flg;
        }

        public float getProgress() throws IOException, InterruptedException {
            float progress = 0.0f;
            if (this.getReadResults() != null) {
                progress = this.getReadResults().getProgress();
            }
            return progress;
        }

        public Edge<I, E> getCurrentEdge() throws IOException, InterruptedException {
            return this.edge;
        }

        protected abstract Edge<I, E> transformEdge(Object var1);

        protected void getResults() {
            this.setReadResults(GoraUtils.getRequest(GoraEdgeInputFormat.getDataStore(), GoraEdgeInputFormat.this.getStartKey(), GoraEdgeInputFormat.getEndKey()));
        }

        public void close() throws IOException {
        }

        Result getReadResults() {
            return this.readResults;
        }

        void setReadResults(Result readResults) {
            this.readResults = readResults;
        }
    }
}

