/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.zk;

import java.util.List;
import org.apache.giraph.zk.ZooKeeperExt;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestZooKeeperExt
implements Watcher {
    private ZooKeeperExt zooKeeperExt = null;
    private String zkList = System.getProperty("prop.zookeeper.list");
    public static final String BASE_PATH = "/_zooKeeperExtTest";
    public static final String FIRST_PATH = "/_first";

    public void process(WatchedEvent event) {
    }

    @Before
    public void setUp() {
        try {
            if (this.zkList == null) {
                return;
            }
            this.zooKeeperExt = new ZooKeeperExt(this.zkList, 30000, 0, 0, (Watcher)this);
            this.zooKeeperExt.deleteExt(BASE_PATH, -1, true);
        }
        catch (KeeperException.NoNodeException e) {
            System.out.println("Clean start: No node /_zooKeeperExtTest");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @After
    public void tearDown() {
        if (this.zooKeeperExt == null) {
            return;
        }
        try {
            this.zooKeeperExt.close();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testCreateExt() throws KeeperException, InterruptedException {
        if (this.zooKeeperExt == null) {
            System.out.println("testCreateExt: No prop.zookeeper.list set, skipping test");
            return;
        }
        System.out.println("Created: " + this.zooKeeperExt.createExt("/_zooKeeperExtTest/_first", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, true));
        this.zooKeeperExt.deleteExt("/_zooKeeperExtTest/_first", -1, false);
        this.zooKeeperExt.deleteExt(BASE_PATH, -1, false);
    }

    @Test
    public void testDeleteExt() throws KeeperException, InterruptedException {
        if (this.zooKeeperExt == null) {
            System.out.println("testDeleteExt: No prop.zookeeper.list set, skipping test");
            return;
        }
        this.zooKeeperExt.createExt(BASE_PATH, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, false);
        this.zooKeeperExt.createExt("/_zooKeeperExtTest/_first", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, false);
        try {
            this.zooKeeperExt.deleteExt(BASE_PATH, -1, false);
        }
        catch (KeeperException.NotEmptyException e) {
            System.out.println("Correctly failed to delete since not recursive");
        }
        this.zooKeeperExt.deleteExt(BASE_PATH, -1, true);
    }

    @Test
    public void testGetChildrenExt() throws KeeperException, InterruptedException {
        if (this.zooKeeperExt == null) {
            System.out.println("testGetChildrenExt: No prop.zookeeper.list set, skipping test");
            return;
        }
        this.zooKeeperExt.createExt(BASE_PATH, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, false);
        this.zooKeeperExt.createExt("/_zooKeeperExtTest/b", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL, false);
        this.zooKeeperExt.createExt("/_zooKeeperExtTest/a", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL, false);
        this.zooKeeperExt.createExt("/_zooKeeperExtTest/d", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL, false);
        this.zooKeeperExt.createExt("/_zooKeeperExtTest/c", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL, false);
        List fullPathList = this.zooKeeperExt.getChildrenExt(BASE_PATH, false, false, true);
        for (String fullPath : fullPathList) {
            Assert.assertTrue((boolean)fullPath.contains("/_zooKeeperExtTest/"));
        }
        List sequenceOrderedList = this.zooKeeperExt.getChildrenExt(BASE_PATH, false, true, true);
        for (String fullPath : sequenceOrderedList) {
            Assert.assertTrue((boolean)fullPath.contains("/_zooKeeperExtTest/"));
        }
        Assert.assertEquals((long)4L, (long)sequenceOrderedList.size());
        Assert.assertTrue((boolean)((String)sequenceOrderedList.get(0)).contains("/b"));
        Assert.assertTrue((boolean)((String)sequenceOrderedList.get(1)).contains("/a"));
        Assert.assertTrue((boolean)((String)sequenceOrderedList.get(2)).contains("/d"));
        Assert.assertTrue((boolean)((String)sequenceOrderedList.get(3)).contains("/c"));
    }
}

