/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.zk;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.giraph.time.Time;
import org.apache.giraph.zk.BspEvent;
import org.apache.giraph.zk.PredicateLock;
import org.apache.hadoop.util.Progressable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestPredicateLock {
    private AtomicInteger progressCalled = new AtomicInteger(0);
    private Progressable stubContext;

    private Progressable getStubProgressable() {
        if (this.stubContext == null) {
            this.stubContext = new Progressable(){

                public void progress() {
                    TestPredicateLock.this.progressCalled.incrementAndGet();
                }
            };
        }
        return this.stubContext;
    }

    @Before
    public void setUp() {
        this.progressCalled.set(0);
    }

    @Test
    public void testWaitMsecsNoEvent() {
        Time mockTime = (Time)Mockito.mock(Time.class);
        Mockito.when((Object)mockTime.getMilliseconds()).thenReturn((Object)0L).thenReturn((Object)2L);
        PredicateLock event = new PredicateLock(this.getStubProgressable(), 1, mockTime);
        boolean gotPredicate = event.waitMsecs(1);
        Assert.assertFalse((boolean)gotPredicate);
        Assert.assertEquals((long)0L, (long)this.progressCalled.get());
        Mockito.when((Object)mockTime.getMilliseconds()).thenReturn((Object)0L).thenReturn((Object)0L).thenReturn((Object)2L);
        gotPredicate = event.waitMsecs(1);
        Assert.assertFalse((boolean)gotPredicate);
        Assert.assertEquals((long)1L, (long)this.progressCalled.get());
    }

    @Test
    public void testEvent() {
        Time mockTime = (Time)Mockito.mock(Time.class);
        Mockito.when((Object)mockTime.getMilliseconds()).thenReturn((Object)0L).thenReturn((Object)2L);
        PredicateLock event = new PredicateLock(this.getStubProgressable(), 1, mockTime);
        event.signal();
        boolean gotPredicate = event.waitMsecs(2);
        Assert.assertTrue((boolean)gotPredicate);
        event.reset();
        Mockito.when((Object)mockTime.getMilliseconds()).thenReturn((Object)0L).thenReturn((Object)2L);
        gotPredicate = event.waitMsecs(0);
        Assert.assertFalse((boolean)gotPredicate);
    }

    @Test
    public void testWaitForever() {
        PredicateLock event = new PredicateLock(this.getStubProgressable());
        SignalThread signalThread = new SignalThread((BspEvent)event);
        signalThread.start();
        event.waitForever();
        try {
            signalThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)event.waitMsecs(0));
    }

    @Test
    public void testWaitMsecs() {
        PredicateLock event = new PredicateLock(this.getStubProgressable());
        SignalThread signalThread = new SignalThread((BspEvent)event);
        signalThread.start();
        boolean gotPredicate = event.waitMsecs(2000);
        Assert.assertTrue((boolean)gotPredicate);
        try {
            signalThread.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        gotPredicate = event.waitMsecs(0);
        Assert.assertTrue((boolean)gotPredicate);
    }

    private static class SignalThread
    extends Thread {
        private final BspEvent event;

        public SignalThread(BspEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.event.signal();
        }
    }
}

