/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.giraph.utils.WritableUtils;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.LongWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestWritableUtils {
    @Test
    public void testListSerialization() throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new LongWritable(1L));
        list.add(new LongWritable(2L));
        list.add(null);
        list.add(new FloatWritable(3.0f));
        list.add(new FloatWritable(4.0f));
        list.add(new LongWritable(5L));
        list.add(new LongWritable(6L));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        WritableUtils.writeList(list, (DataOutput)dos);
        dos.close();
        byte[] data = bos.toByteArray();
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(data));
        List result = WritableUtils.readList((DataInput)input);
        Assert.assertEquals(list, (Object)result);
    }

    @Test
    public void testIntArray() throws IOException {
        int[] array = new int[]{1, 2, 3, 4, 5};
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        WritableUtils.writeIntArray((int[])array, (DataOutput)dos);
        dos.close();
        byte[] data = bos.toByteArray();
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(data));
        int[] result = WritableUtils.readIntArray((DataInput)input);
        Assert.assertArrayEquals((int[])array, (int[])result);
    }

    @Test
    public void testLongArray() throws IOException {
        long[] array = new long[]{1L, 2L, 3L, 4L, 5L};
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        WritableUtils.writeLongArray((DataOutput)dos, (long[])array);
        dos.close();
        byte[] data = bos.toByteArray();
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(data));
        long[] result = WritableUtils.readLongArray((DataInput)input);
        Assert.assertArrayEquals((long[])array, (long[])result);
    }
}

