/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import java.io.IOException;
import org.apache.giraph.utils.UnsafeByteArrayInputStream;
import org.apache.giraph.utils.UnsafeByteArrayOutputStream;
import org.junit.Assert;
import org.junit.Test;

public class TestUnsafeByteArrayOutputStream {
    @Test
    public void testWriteBytes() throws IOException {
        UnsafeByteArrayOutputStream os = new UnsafeByteArrayOutputStream();
        int length = os.getByteArray().length;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append("\u00ea");
        }
        String s = sb.toString();
        os.writeBytes(s);
        UnsafeByteArrayInputStream is = new UnsafeByteArrayInputStream(os.getByteArray());
        for (int i = 0; i < s.length(); ++i) {
            Assert.assertEquals((long)((byte)s.charAt(i)), (long)is.readByte());
        }
        os.close();
    }

    @Test
    public void testWriteChars() throws IOException {
        UnsafeByteArrayOutputStream os = new UnsafeByteArrayOutputStream();
        int length = os.getByteArray().length;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append("\u10ea");
        }
        String s = sb.toString();
        os.writeChars(s);
        UnsafeByteArrayInputStream is = new UnsafeByteArrayInputStream(os.getByteArray());
        for (int i = 0; i < s.length(); ++i) {
            Assert.assertEquals((long)s.charAt(i), (long)is.readChar());
        }
        os.close();
    }

    @Test
    public void testWriteUTF() throws IOException {
        UnsafeByteArrayOutputStream os = new UnsafeByteArrayOutputStream();
        int length = os.getByteArray().length;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append("\u06ea");
        }
        String s = sb.toString();
        os.writeUTF(s);
        UnsafeByteArrayInputStream is = new UnsafeByteArrayInputStream(os.getByteArray());
        Assert.assertEquals((Object)s, (Object)is.readUTF());
        os.close();
    }
}

