/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import java.io.IOException;
import org.apache.giraph.conf.TypesHolder;
import org.apache.giraph.edge.ByteArrayEdges;
import org.apache.giraph.edge.OutEdges;
import org.apache.giraph.factories.DefaultEdgeValueFactory;
import org.apache.giraph.factories.DefaultIncomingMessageValueFactory;
import org.apache.giraph.factories.DefaultOutgoingMessageValueFactory;
import org.apache.giraph.factories.DefaultVertexIdFactory;
import org.apache.giraph.factories.DefaultVertexValueFactory;
import org.apache.giraph.factories.EdgeValueFactory;
import org.apache.giraph.factories.MessageValueFactory;
import org.apache.giraph.factories.VertexIdFactory;
import org.apache.giraph.factories.VertexValueFactory;
import org.apache.giraph.graph.AbstractComputation;
import org.apache.giraph.graph.BasicComputation;
import org.apache.giraph.graph.Computation;
import org.apache.giraph.graph.DefaultVertexResolver;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.graph.VertexResolver;
import org.apache.giraph.utils.ReflectionUtils;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.junit.Assert;
import org.junit.Test;

public class TestReflectionUtils {
    @Test
    public void testPackagePath() {
        Assert.assertEquals((Object)"org/apache/giraph/utils", (Object)ReflectionUtils.getPackagePath(TestReflectionUtils.class));
        Assert.assertEquals((Object)"org/apache/giraph/utils", (Object)ReflectionUtils.getPackagePath(this.getClass()));
        Assert.assertEquals((Object)"org/apache/giraph/utils", (Object)ReflectionUtils.getPackagePath((Object)this));
    }

    @Test
    public void testInferWithGenerics() {
        Class[] classes = ReflectionUtils.getTypeArguments(VertexResolver.class, DefaultVertexResolver.class);
        Assert.assertEquals((long)3L, (long)classes.length);
        Assert.assertEquals(WritableComparable.class, (Object)classes[0]);
        Assert.assertEquals(Writable.class, (Object)classes[1]);
        Assert.assertEquals(Writable.class, (Object)classes[2]);
        classes = ReflectionUtils.getTypeArguments(VertexIdFactory.class, DefaultVertexIdFactory.class);
        Assert.assertEquals((long)1L, (long)classes.length);
        Assert.assertEquals(WritableComparable.class, (Object)classes[0]);
        classes = ReflectionUtils.getTypeArguments(VertexValueFactory.class, DefaultVertexValueFactory.class);
        Assert.assertEquals((long)1L, (long)classes.length);
        Assert.assertEquals(Writable.class, (Object)classes[0]);
        classes = ReflectionUtils.getTypeArguments(EdgeValueFactory.class, DefaultEdgeValueFactory.class);
        Assert.assertEquals((long)1L, (long)classes.length);
        Assert.assertEquals(Writable.class, (Object)classes[0]);
        classes = ReflectionUtils.getTypeArguments(MessageValueFactory.class, DefaultIncomingMessageValueFactory.class);
        Assert.assertEquals((long)1L, (long)classes.length);
        Assert.assertEquals(Writable.class, (Object)classes[0]);
        classes = ReflectionUtils.getTypeArguments(MessageValueFactory.class, DefaultOutgoingMessageValueFactory.class);
        Assert.assertEquals((long)1L, (long)classes.length);
        Assert.assertEquals(Writable.class, (Object)classes[0]);
        classes = ReflectionUtils.getTypeArguments(OutEdges.class, ByteArrayEdges.class);
        Assert.assertEquals((long)2L, (long)classes.length);
        Assert.assertEquals(WritableComparable.class, (Object)classes[0]);
        Assert.assertEquals(Writable.class, (Object)classes[1]);
    }

    @Test
    public void testInferTypeParams() {
        this.checkTypes(TypesHolder.class, IntTypes.class, 5);
        this.checkTypes(TypesHolder.class, IntComputation.class, 5);
        this.checkTypes(Computation.class, IntComputation.class, 5);
        this.checkTypes(TypesHolder.class, IntBasicComputation.class, 5);
        this.checkTypes(Computation.class, IntBasicComputation.class, 5);
        this.checkTypes(BasicComputation.class, IntBasicComputation.class, 4);
    }

    private <T> void checkTypes(Class<T> baseClass, Class<? extends T> childClass, int numArgs) {
        Class[] classes = ReflectionUtils.getTypeArguments(baseClass, childClass);
        Assert.assertEquals((long)numArgs, (long)classes.length);
        for (Class klass : classes) {
            Assert.assertEquals(IntWritable.class, (Object)klass);
        }
    }

    private static class IntBasicComputation
    extends BasicComputation<IntWritable, IntWritable, IntWritable, IntWritable> {
        private IntBasicComputation() {
        }

        public void compute(Vertex<IntWritable, IntWritable, IntWritable> vertex, Iterable<IntWritable> messages) throws IOException {
        }
    }

    private static class IntComputation
    extends AbstractComputation<IntWritable, IntWritable, IntWritable, IntWritable, IntWritable> {
        private IntComputation() {
        }

        public void compute(Vertex<IntWritable, IntWritable, IntWritable> vertex, Iterable<IntWritable> messages) throws IOException {
        }
    }

    private static class IntTypes
    implements TypesHolder<IntWritable, IntWritable, IntWritable, IntWritable, IntWritable> {
        private IntTypes() {
        }
    }
}

